/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={Resource.class})
@ProviderType
public class i18nHelper {
    private Resource resource;
    private Set<String> keys = new HashSet<String>();
    private Random rand = new Random();

    public i18nHelper(Resource resource) {
        this.resource = resource;
    }

    public Set<String> getKeys() {
        if (this.keys.isEmpty()) {
            Iterator messageEntries = this.resource.getResourceResolver().findResources("SELECT * FROM [sling:MessageEntry] AS s WHERE ISDESCENDANTNODE([" + this.resource.getPath() + "])", "JCR-SQL2");
            while (messageEntries.hasNext()) {
                Resource entry = (Resource)messageEntries.next();
                this.keys.add((String)entry.getValueMap().get("sling:key", String.class));
            }
        }
        return this.keys;
    }

    public String getRandom() {
        return String.valueOf(this.rand.nextInt());
    }
}

