/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.servlets;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Sling CMS version info servlet", "service.vendor=The Apache Software Foundation", "sling.servlet.resourceTypes=sling-cms/components/cms/versionmanager", "sling.servlet.methods=GET", "sling.servlet.selectors=VI", "sling.servlet.extensions=json"}, immediate=true)
public class VersionInfoServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(VersionInfoServlet.class);
    private static final long serialVersionUID = 2980892473913646093L;

    public void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        log.trace("doGet");
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        try {
            resp.getWriter().write(this.getJsonObject(req.getRequestPathInfo().getSuffixResource()).toString());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private JsonObject getJsonObject(Resource resource) throws RepositoryException {
        log.debug("Loading version history from {}", (Object)resource);
        JsonObjectBuilder result = Json.createObjectBuilder();
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null || !node.isNodeType("mix:versionable")) {
            return result.build();
        }
        VersionHistory history = node.getVersionHistory();
        Version baseVersion = node.getBaseVersion();
        VersionIterator it = history.getAllVersions();
        while (it.hasNext()) {
            Version v = it.nextVersion();
            JsonObjectBuilder obj = Json.createObjectBuilder();
            obj.add("created", VersionInfoServlet.createdDate((Node)v));
            obj.add("successors", this.getArrayBuilder(VersionInfoServlet.getNames(v.getSuccessors())));
            obj.add("predecessors", this.getArrayBuilder(VersionInfoServlet.getNames(v.getPredecessors())));
            obj.add("labels", this.getArrayBuilder(history.getVersionLabels(v)));
            obj.add("baseVersion", baseVersion.isSame((Item)v));
            result.add(v.getName(), obj);
        }
        return Json.createObjectBuilder().add("versions", result).build();
    }

    private JsonArrayBuilder getArrayBuilder(String[] values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String value : values) {
            builder.add(value);
        }
        return builder;
    }

    private JsonArrayBuilder getArrayBuilder(Collection<String> values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String value : values) {
            builder.add(value);
        }
        return builder;
    }

    private static Collection<String> getNames(Version[] versions) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        for (Version s : versions) {
            result.add(s.getName());
        }
        return result;
    }

    private static String createdDate(Node node) throws RepositoryException {
        Property prop = node.getProperty("jcr:created");
        if (prop != null) {
            return new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z").format(prop.getDate().getTime());
        }
        return "";
    }
}

