/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.rewriter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Serializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTML5Serializer
implements Serializer {
    private static final int CHAR_EQ = 61;
    private static final int CHAR_GT = 62;
    private static final int CHAR_SP = 32;
    private static final int CHAR_LT = 60;
    private final Set<String> emptyTags = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("br");
            this.add("area");
            this.add("link");
            this.add("img");
            this.add("param");
            this.add("hr");
            this.add("input");
            this.add("col");
            this.add("base");
            this.add("meta");
        }
    };
    private PrintWriter writer;
    private ConfigurationResourceResolver resolver;
    private Resource rewriteConfig;

    public HTML5Serializer(ConfigurationResourceResolver resolver) {
        this.resolver = resolver;
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (length == 0) {
            this.writer.flush();
        } else {
            this.writer.write(buffer, offset, length);
        }
    }

    public void dispose() {
    }

    public void endDocument() throws SAXException {
        this.writer.flush();
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!this.emptyTags.contains(localName)) {
            this.writer.write("</");
            this.writer.write(localName);
            this.writer.write(62);
        }
    }

    public void endPrefixMapping(String s) throws SAXException {
    }

    public void ignorableWhitespace(char[] ac, int i, int j) throws SAXException {
    }

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        if (context.getWriter() == null) {
            throw new IllegalArgumentException("Failed to initialize HTML5Serializer, null writer specified!");
        }
        this.writer = context.getWriter();
        this.rewriteConfig = this.resolver.getResource(context.getRequest().getResource(), "site", "rewrite");
    }

    public void processingInstruction(String s, String s1) throws SAXException {
    }

    public void setDocumentLocator(Locator locator1) {
    }

    public void skippedEntity(String s) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.writer.println((String)this.rewriteConfig.getValueMap().get("doctype", String.class));
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        boolean endSlash = false;
        this.writer.write(60);
        this.writer.write(localName);
        for (int i = 0; i < atts.getLength(); ++i) {
            if ("endSlash".equals(atts.getQName(i))) {
                endSlash = true;
                continue;
            }
            this.writer.write(32);
            this.writer.write(atts.getLocalName(i));
            String value = atts.getValue(i);
            if (value == null) continue;
            this.writer.write(61);
            this.writer.write(34);
            this.writer.write(value);
            this.writer.write(34);
        }
        if (endSlash) {
            this.writer.write("/");
        }
        this.writer.write(62);
    }

    public void startPrefixMapping(String s, String s1) throws SAXException {
    }
}

