/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.PageTemplate;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class}, adapters={PageTemplate.class})
public class PageTemplateImpl
implements PageTemplate {
    @Inject
    @Optional
    private String[] allowedPaths;
    @Inject
    @Optional
    private String[] availableComponentTypes;
    @Inject
    @Optional
    private List<Resource> componentConfigurations;
    @Inject
    private List<Resource> fields;
    private Resource resource;
    @Inject
    @Optional
    private String template;
    @Inject
    @Named(value="jcr:title")
    private String title;

    public PageTemplateImpl(Resource resource) {
        this.resource = resource;
    }

    public String[] getAllowedPaths() {
        if (this.allowedPaths == null) {
            return new String[0];
        }
        return this.allowedPaths;
    }

    public String[] getAvailableComponentTypes() {
        return this.availableComponentTypes;
    }

    public Map<String, Resource> getComponentConfigs() {
        HashMap<String, Resource> configs = new HashMap<String, Resource>();
        if (this.componentConfigurations != null) {
            for (Resource cfg : this.componentConfigurations) {
                configs.put((String)cfg.getValueMap().get("type", String.class), cfg);
            }
        }
        return configs;
    }

    public List<Resource> getFields() {
        return this.fields;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return "PageTemplate [allowedPaths=" + Arrays.toString(this.allowedPaths) + ", availableComponentTypes=" + Arrays.toString(this.availableComponentTypes) + ", fields=" + this.fields + ", resource=" + this.resource + ", template=" + this.template + ", title=" + this.title + "]";
    }
}

