/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.Component;
import org.apache.sling.cms.EditableResource;
import org.apache.sling.cms.core.internal.models.EditableResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.osgi.service.component.annotations.Component(service={Filter.class}, property={"sling.filter.scope=component"})
public class EditIncludeFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(EditIncludeFilter.class);
    public static final String ENABLED_ATTR_NAME = "cmsEditEnabled";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Resource resource = ((SlingHttpServletRequest)request).getResource();
        boolean enabled = "true".equals(request.getAttribute(ENABLED_ATTR_NAME));
        String editPath = this.getEditPath(resource);
        PrintWriter writer = null;
        if (enabled && StringUtils.isNotEmpty((String)editPath)) {
            boolean last = false;
            boolean first = false;
            if (resource != null && resource.getParent() != null) {
                Iterator children = resource.getParent().listChildren();
                if (!children.hasNext() || ((Resource)children.next()).getPath().equals(resource.getPath())) {
                    first = true;
                }
                if (children.hasNext()) {
                    while (children.hasNext()) {
                        if (!((Resource)children.next()).getPath().equals(resource.getPath()) || children.hasNext()) continue;
                        last = true;
                    }
                } else {
                    last = true;
                }
            }
            boolean exists = resource.getResourceResolver().getResource(resource.getPath()) != null;
            writer = response.getWriter();
            Component component = null;
            EditableResource er = (EditableResource)resource.adaptTo(EditableResource.class);
            if (er != null) {
                component = er.getComponent();
            }
            writer.write("<div class=\"sling-cms-component\" data-sling-cms-title=\"" + (component != null ? component.getTitle() : "") + "\" data-sling-cms-resource-path=\"" + resource.getPath() + "\" data-sling-cms-resource-type=\"" + resource.getResourceType() + "\" data-sling-cms-edit=\"" + editPath + "\"><div class=\"sling-cms-editor\">");
            writer.write("<div class=\"level has-background-grey\"><div class=\"level-left\"><div class=\"field has-addons\">");
            writer.write("<div class=\"control\"><button class=\"level-item button\" data-sling-cms-action=\"edit\" data-sling-cms-path=\"" + resource.getPath() + "\" data-sling-cms-edit=\"" + editPath + "\" title=\"Edit\"><span class=\"jam jam-pencil-f\"></span></button></div>");
            if (!first || !last) {
                writer.write("<div class=\"control\"><button class=\"level-item button\" data-sling-cms-action=\"reorder\" data-sling-cms-path=\"" + resource.getPath() + "\" title=\"Reorder\"><span class=\"jam jam-arrows-v\"></span></button></div>");
            }
            if (!resource.getName().equals("jcr:content") && exists) {
                writer.write("<div class=\"control\"><button class=\"level-item button\" data-sling-cms-action=\"delete\" data-sling-cms-path=\"" + resource.getPath() + "\" title=\"Delete\"><span class=\"jam jam-trash\"></span></button></div>");
            }
            writer.write("</div></div>");
            if (component != null) {
                writer.write("<div class=\"level-right\"><div class=\"level-item has-text-light\">" + component.getTitle() + "</div></div>");
            }
            writer.write("</div></div>");
        }
        chain.doFilter(request, response);
        if (enabled && StringUtils.isNotEmpty((String)editPath) && writer != null) {
            writer.write("</div>");
        }
    }

    private String getEditPath(Resource resource) {
        EditableResourceImpl editResource;
        Component component;
        log.trace("getEditPage resource={}", (Object)resource);
        String editPath = null;
        if (resource != null && (component = (editResource = new EditableResourceImpl(resource)).getComponent()) != null && !component.isType("Page")) {
            editPath = component.getEditPath();
        }
        return editPath;
    }

    public void destroy() {
    }
}

