/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.CMSConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMSUtils {
    private CMSUtils() {
    }

    @NotNull
    public static final <T> List<T> adaptResources(Collection<Resource> resources, Class<T> type) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (resources != null) {
            for (Resource resource : resources) {
                Object val = resource.adaptTo(type);
                if (val == null) continue;
                values.add(val);
            }
        }
        return values;
    }

    @NotNull
    public static final <T> List<T> adaptResources(Resource[] resources, Class<T> type) {
        return CMSUtils.adaptResources(Arrays.asList(resources), type);
    }

    @Nullable
    public static final Resource findParentResourceofType(Resource resource, String type) {
        if (resource != null) {
            if (type.equals(resource.getValueMap().get("jcr:primaryType", String.class))) {
                return resource;
            }
            return CMSUtils.findParentResourceofType(resource.getParent(), type);
        }
        return null;
    }

    @Nullable
    public static final Resource findPublishableParent(Resource resource) {
        if (resource != null) {
            String type = (String)resource.getValueMap().get("jcr:primaryType", String.class);
            if (ArrayUtils.contains((Object[])CMSConstants.PUBLISHABLE_TYPES, (Object)type)) {
                return resource;
            }
            if (resource.getParent() != null) {
                return CMSUtils.findPublishableParent(resource.getParent());
            }
        }
        return null;
    }

    public static final boolean isPublished(Resource resource) {
        Resource content;
        boolean published = true;
        Resource publishable = CMSUtils.findPublishableParent(resource);
        if (publishable != null && (content = publishable.getChild("jcr:content")) != null && !((Boolean)content.getValueMap().get("published", (Object)false)).booleanValue()) {
            published = false;
        }
        return published;
    }
}

