/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;

public class ResourceTree {
    private Resource root;

    public static Stream<ResourceTree> stream(Resource resource) {
        return new ResourceTree(resource).streamTree();
    }

    public static Stream<ResourceTree> stream(Resource resource, String filterType) {
        return new ResourceTree(resource).streamTree(filterType);
    }

    private ResourceTree(Resource root) {
        this.root = root;
    }

    public Resource getResource() {
        return this.root;
    }

    private Stream<ResourceTree> streamTree() {
        return Stream.concat(Stream.of(this), StreamSupport.stream(this.root.getChildren().spliterator(), false).map(ResourceTree::new).flatMap(ResourceTree::streamTree));
    }

    private Stream<ResourceTree> streamTree(String filterType) {
        return Stream.concat(Stream.of(this), StreamSupport.stream(this.root.getChildren().spliterator(), false).filter(c -> filterType.equals(c.getResourceType())).map(ResourceTree::new).flatMap(rt -> rt.streamTree(filterType)));
    }
}

