/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.result.internal;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.jcr.PropertyType;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.clam.internal.ClamUtil;
import org.apache.sling.clam.result.JcrPropertyScanResultHandler;
import org.apache.sling.clam.result.internal.ResourcePersistingScanResultHandlerConfiguration;
import org.apache.sling.commons.clam.ScanResult;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Apache Sling Clam Resource Persisting Scan Result Handler", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ResourcePersistingScanResultHandlerConfiguration.class)
public class ResourcePersistingScanResultHandler
implements JcrPropertyScanResultHandler {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ResourceResolverFactory resourceResolverFactory;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(subServiceName=result-writer)")
    private volatile ServiceUserMapped serviceUserMapped;
    private ResourcePersistingScanResultHandlerConfiguration configuration;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss/SSS");
    private static final String NT_SLING_ORDERED_FOLDER = "sling:OrderedFolder";
    private static final String SLING_RESOURCE_TYPE_PROPERTY = "sling:resourceType";
    private static final String RESULT_RESOURCE_TYPE = "sling/clam/result";
    private static final String SUBSERVICE = "result-writer";
    private final Logger logger = LoggerFactory.getLogger(ResourcePersistingScanResultHandler.class);

    @Activate
    private void activate(ResourcePersistingScanResultHandlerConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
    }

    @Modified
    private void modified(ResourcePersistingScanResultHandlerConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
    }

    @Override
    public void handleJcrPropertyScanResult(@NotNull ScanResult scanResult, @NotNull String path, int propertyType, @NotNull String userId) {
        if (this.checkPersist(scanResult)) {
            this.persistResult(scanResult, path, null, propertyType, userId);
        }
    }

    @Override
    public void handleJcrPropertyScanResult(@NotNull ScanResult scanResult, @NotNull String path, int index, int propertyType, @Nullable String userId) {
        if (this.checkPersist(scanResult)) {
            this.persistResult(scanResult, path, index, propertyType, userId);
        }
    }

    private boolean checkPersist(ScanResult scanResult) {
        return !scanResult.isOk() || scanResult.isOk() && this.configuration.result_status_ok_persist();
    }

    private void persistResult(@NotNull ScanResult scanResult, @NotNull String path, Integer index, int propertyType, @Nullable String userId) {
        try (ResourceResolver resourceResolver = this.serviceResourceResolver();){
            Map<String, Object> properties = ClamUtil.properties(path, index, userId, scanResult);
            properties.put("jcr:primaryType", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
            properties.put("jcr:mixinTypes", "{http://www.jcp.org/jcr/mix/1.0}created");
            properties.put(SLING_RESOURCE_TYPE_PROPERTY, RESULT_RESOURCE_TYPE);
            Resource parent = this.getOrCreateParent(resourceResolver, scanResult.getTimestamp());
            String name = ResourceUtil.createUniqueChildName((Resource)parent, (String)PropertyType.nameFromValue((int)propertyType));
            Resource result = resourceResolver.create(parent, name, properties);
            resourceResolver.commit();
            if (index == null) {
                this.logger.debug("Scan result for {} persisted at {}.", (Object)path, (Object)result.getPath());
            } else {
                this.logger.debug("Scan result for {} [{}] persisted at {}.", new Object[]{path, index, result.getPath()});
            }
        }
        catch (LoginException | PersistenceException e) {
            throw new RuntimeException(e);
        }
    }

    private Resource getOrCreateParent(ResourceResolver resourceResolver, long timestamp) throws PersistenceException {
        Date date = new Date(timestamp);
        String path = String.format("%s/%s", this.configuration.result_root_path(), FORMAT.format(date));
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)path, (String)NT_SLING_ORDERED_FOLDER, (String)NT_SLING_ORDERED_FOLDER, (boolean)true);
    }

    private ResourceResolver serviceResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SUBSERVICE));
    }
}

