/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.result.internal;

import org.apache.sling.clam.internal.ClamUtil;
import org.apache.sling.clam.result.JcrPropertyScanResultHandler;
import org.apache.sling.clam.result.internal.EventPublishingScanResultHandlerConfiguration;
import org.apache.sling.commons.clam.ScanResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Apache Sling Clam Event Publishing Scan Result Handler", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=EventPublishingScanResultHandlerConfiguration.class)
public class EventPublishingScanResultHandler
implements JcrPropertyScanResultHandler {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile EventAdmin eventAdmin;
    private EventPublishingScanResultHandlerConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(EventPublishingScanResultHandler.class);

    @Activate
    private void activate(EventPublishingScanResultHandlerConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
    }

    @Modified
    private void modified(EventPublishingScanResultHandlerConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
    }

    @Override
    public void handleJcrPropertyScanResult(@NotNull ScanResult scanResult, @NotNull String path, int propertyType, @Nullable String userId) {
        if (this.checkPublish(scanResult)) {
            Event event = new Event(ClamUtil.resultEventTopic(propertyType), ClamUtil.properties(path, userId, scanResult));
            this.eventAdmin.postEvent(event);
        }
    }

    @Override
    public void handleJcrPropertyScanResult(@NotNull ScanResult scanResult, @NotNull String path, int index, int propertyType, @Nullable String userId) {
        if (this.checkPublish(scanResult)) {
            Event event = new Event(ClamUtil.resultEventTopic(propertyType), ClamUtil.properties(path, index, userId, scanResult));
            this.eventAdmin.postEvent(event);
        }
    }

    private boolean checkPublish(ScanResult scanResult) {
        return !scanResult.isOk() || scanResult.isOk() && this.configuration.result_status_ok_publish();
    }
}

