/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.oak.internal;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.plugins.observation.NodeObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.clam.internal.ClamUtil;
import org.apache.sling.clam.oak.internal.NodeObservingJcrPropertyDiggerConfiguration;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"service.description=Apache Sling Clam Node Observing JCR Property Digger", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=NodeObservingJcrPropertyDiggerConfiguration.class, factory=true)
public class NodeObservingJcrPropertyDigger
extends NodeObserver {
    @Reference
    private volatile NodeStore nodeStore;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ResourceResolverFactory resourceResolverFactory;
    @Reference
    private volatile ThreadPoolManager threadPoolManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile JobManager jobManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ServiceUserMapped serviceUserMapped;
    private Pattern pattern;
    private int propertyType;
    private ThreadPool threadPool;
    private Closeable closeable;
    private NodeObservingJcrPropertyDiggerConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(NodeObservingJcrPropertyDigger.class);

    public NodeObservingJcrPropertyDigger() {
        super("/", new String[0]);
    }

    @Activate
    private void activate(NodeObservingJcrPropertyDiggerConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.configure(configuration);
        this.threadPool = this.threadPoolManager.get(configuration.threadpool_name());
        Observable observable = (Observable)this.nodeStore;
        this.closeable = observable.addObserver((Observer)this);
    }

    @Modified
    private void modified(NodeObservingJcrPropertyDiggerConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        try {
            this.closeable.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        this.threadPoolManager.release(this.threadPool);
        this.configuration = null;
    }

    private void configure(NodeObservingJcrPropertyDiggerConfiguration configuration) {
        this.pattern = Pattern.compile(configuration.property_path_pattern());
        this.propertyType = PropertyType.valueFromName((String)configuration.property_type());
    }

    protected void added(@NotNull String path, @NotNull Set<String> added, @NotNull Set<String> deleted, @NotNull Set<String> changed, @NotNull Map<String, String> properties, @NotNull CommitInfo commitInfo) {
        Set<String> names = this.concat(added, changed);
        this.dig(path, names, this.pattern, this.propertyType, this.configuration.property_length_max(), commitInfo.getUserId());
    }

    protected void deleted(@NotNull String path, @NotNull Set<String> added, @NotNull Set<String> deleted, @NotNull Set<String> changed, @NotNull Map<String, String> properties, @NotNull CommitInfo commitInfo) {
    }

    protected void changed(@NotNull String path, @NotNull Set<String> added, @NotNull Set<String> deleted, @NotNull Set<String> changed, @NotNull Map<String, String> properties, @NotNull CommitInfo commitInfo) {
        Set<String> names = this.concat(added, changed);
        this.dig(path, names, this.pattern, this.propertyType, this.configuration.property_length_max(), commitInfo.getUserId());
    }

    private void dig(String path, Set<String> names, Pattern pattern, int propertyType, long maxLength, String userId) {
        DigTask digTask = new DigTask(path, names, pattern, propertyType, maxLength, userId);
        this.threadPool.submit((Runnable)digTask);
    }

    private Set<String> filter(String path, Set<String> names, Pattern pattern) {
        HashSet<String> paths = new HashSet<String>();
        for (String name : names) {
            String p = String.format("%s/%s", path, name);
            if (pattern.matcher(p).matches()) {
                this.logger.debug("path '{}' matches pattern '{}'", (Object)p, (Object)pattern.pattern());
                paths.add(p);
                continue;
            }
            this.logger.debug("path '{}' doesn't match pattern '{}'", (Object)p, (Object)pattern.pattern());
        }
        return paths;
    }

    private boolean checkLength(long length, long maxLength) {
        if (maxLength == -1L) {
            return true;
        }
        return length <= maxLength;
    }

    private Set<String> concat(Set<String> a, Set<String> b) {
        HashSet<String> set = new HashSet<String>(a);
        set.addAll(b);
        return set;
    }

    private class DigTask
    implements Runnable {
        private final String path;
        private final Set<String> names;
        private final Pattern pattern;
        private final int propertyType;
        private final long maxLength;
        private final String userId;

        DigTask(String path, Set<String> names, Pattern pattern, int propertyType, long maxLength, String userId) {
            this.path = path;
            this.names = names;
            this.pattern = pattern;
            this.propertyType = propertyType;
            this.maxLength = maxLength;
            this.userId = userId;
        }

        @Override
        public void run() {
            Set paths = NodeObservingJcrPropertyDigger.this.filter(this.path, this.names, this.pattern);
            try (ResourceResolver resourceResolver = NodeObservingJcrPropertyDigger.this.resourceResolverFactory.getServiceResourceResolver(null);){
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                assert (session != null);
                for (String path : paths) {
                    Property property = session.getProperty(path);
                    int propertyType = property.getType();
                    if (propertyType != this.propertyType) continue;
                    if (property.isMultiple()) {
                        long[] lengths = property.getLengths();
                        for (int index = 0; index < lengths.length; ++index) {
                            long length = lengths[index];
                            if (NodeObservingJcrPropertyDigger.this.checkLength(length, this.maxLength)) {
                                NodeObservingJcrPropertyDigger.this.jobManager.addJob(ClamUtil.scanJobTopic(propertyType), ClamUtil.properties(path, index, this.userId));
                                continue;
                            }
                            NodeObservingJcrPropertyDigger.this.logger.warn("Length of property '{}' [{}] greater than configured max length ({}).", new Object[]{path, index, this.maxLength});
                        }
                        continue;
                    }
                    if (NodeObservingJcrPropertyDigger.this.checkLength(property.getLength(), this.maxLength)) {
                        NodeObservingJcrPropertyDigger.this.jobManager.addJob(ClamUtil.scanJobTopic(propertyType), ClamUtil.properties(path, this.userId));
                        continue;
                    }
                    NodeObservingJcrPropertyDigger.this.logger.warn("Length of property '{}' greater than configured max length ({}).", (Object)path, (Object)this.maxLength);
                }
            }
            catch (Exception e) {
                NodeObservingJcrPropertyDigger.this.logger.error(e.getMessage());
            }
        }
    }
}

