/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.job.internal;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.clam.result.JcrPropertyScanResultHandler;
import org.apache.sling.commons.clam.ClamService;
import org.apache.sling.commons.clam.ScanResult;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"job.topics=org/apache/sling/clam/scan/jcr/property/*", "service.description=Apache Sling Clam JCR Property Scan Job Consumer", "service.vendor=The Apache Software Foundation"})
public class JcrPropertyScanJobConsumer
implements JobConsumer {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ResourceResolverFactory resourceResolverFactory;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ClamService clamService;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<JcrPropertyScanResultHandler> scanResultHandlers;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ServiceUserMapped serviceUserMapped;
    private final Logger logger = LoggerFactory.getLogger(JcrPropertyScanJobConsumer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobConsumer.JobResult process(Job job) {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);){
            String path = (String)job.getProperty("path", String.class);
            String userId = (String)job.getProperty("userId", String.class);
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            assert (session != null);
            Property property = session.getProperty(path);
            int propertyType = property.getType();
            if (property.isMultiple()) {
                int index = (Integer)job.getProperty("index", Integer.class);
                Value[] values = property.getValues();
                Value value = values[index];
                try (InputStream inputStream = this.getInputStream(value);){
                    ScanResult scanResult = this.clamService.scan(inputStream);
                    this.invokeScanResultHandlers(scanResult, path, index, propertyType, userId);
                }
            }
            try (InputStream inputStream = this.getInputStream(property.getValue());){
                ScanResult scanResult = this.clamService.scan(inputStream);
                this.invokeScanResultHandlers(scanResult, path, null, propertyType, userId);
            }
            JobConsumer.JobResult jobResult = JobConsumer.JobResult.OK;
            return jobResult;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return JobConsumer.JobResult.FAILED;
        }
    }

    private InputStream getInputStream(Value value) throws Exception {
        int propertyType = value.getType();
        switch (propertyType) {
            case 2: {
                return value.getBinary().getStream();
            }
            case 1: {
                return IOUtils.toInputStream((String)value.getString(), (Charset)StandardCharsets.UTF_8);
            }
        }
        throw new Exception("Unsupported property type: " + PropertyType.nameFromValue((int)propertyType));
    }

    private void invokeScanResultHandlers(ScanResult scanResult, String path, Integer index, int propertyType, String userId) {
        if (this.scanResultHandlers != null) {
            for (JcrPropertyScanResultHandler scanResultHandler : this.scanResultHandlers) {
                try {
                    if (index == null) {
                        scanResultHandler.handleJcrPropertyScanResult(scanResult, path, propertyType, userId);
                        continue;
                    }
                    scanResultHandler.handleJcrPropertyScanResult(scanResult, path, index, propertyType, userId);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

