/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.internal;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.PropertyType;
import org.apache.sling.commons.clam.ScanResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClamUtil {
    public static final String PROPERTY_PATH = "path";
    public static final String VALUE_INDEX = "index";
    public static final String USER_ID = "userId";
    private static final String SCAN_JOB_TOPIC_ROOT = "org/apache/sling/clam/scan/jcr/property";
    private static final String RESULT_EVENT_TOPIC_ROOT = "org/apache/sling/clam/result/jcr/property";

    public static String scanJobTopic(int propertyType) {
        return String.format("%s/%s", SCAN_JOB_TOPIC_ROOT, PropertyType.nameFromValue((int)propertyType));
    }

    public static String resultEventTopic(int propertyType) {
        return String.format("%s/%s", RESULT_EVENT_TOPIC_ROOT, PropertyType.nameFromValue((int)propertyType));
    }

    public static Map<String, Object> properties(@NotNull String path, @Nullable String userId) {
        return ClamUtil.properties(path, null, userId);
    }

    public static Map<String, Object> properties(@NotNull String path, @Nullable Integer index, @Nullable String userId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(PROPERTY_PATH, path);
        if (index != null) {
            properties.put(VALUE_INDEX, index);
        }
        if (userId != null) {
            properties.put(USER_ID, userId);
        }
        return properties;
    }

    public static Map<String, Object> properties(@NotNull String path, @Nullable String userId, @NotNull ScanResult scanResult) {
        return ClamUtil.properties(path, null, userId, scanResult);
    }

    public static Map<String, Object> properties(@NotNull String path, @Nullable Integer index, @Nullable String userId, @NotNull ScanResult scanResult) {
        Map<String, Object> properties = ClamUtil.properties(path, index, userId);
        properties.put("timestamp", scanResult.getTimestamp());
        properties.put("message", scanResult.getMessage());
        properties.put("status", scanResult.getStatus().name());
        return properties;
    }
}

