/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.capabilities.internal;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.capabilities.CapabilitiesSource;
import org.apache.sling.capabilities.internal.JSONCapabilitiesWriter;
import org.apache.sling.capabilities.internal.RegexFilter;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=sling/capabilities", "sling.servlet.methods=GET", "sling.servlet.extensions=json"})
@Designate(ocd=Config.class)
public class CapabilitiesServlet
extends SlingSafeMethodsServlet {
    private final List<CapabilitiesSource> sources = new CopyOnWriteArrayList<CapabilitiesSource>();
    private RegexFilter pathFilter;
    public static final String NAMESPACES_PROP = "namespace_patterns";

    @Activate
    protected void activate(Config cfg, ComponentContext ctx) {
        this.pathFilter = new RegexFilter(cfg.resourcePathPatterns());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.sources.size() + " " + CapabilitiesSource.class.getSimpleName() + " active";
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String path = request.getResource().getPath();
        if (!this.pathFilter.accept(path)) {
            response.sendError(403, "Invalid path " + path);
            return;
        }
        ValueMap m = (ValueMap)request.getResource().adaptTo(ValueMap.class);
        String[] namespacePatterns = (String[])m.get(NAMESPACES_PROP, String[].class);
        if (namespacePatterns == null) {
            response.sendError(403, "Missing property namespace_patterns");
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        new JSONCapabilitiesWriter().writeJson(response.getWriter(), this.sources, new RegexFilter(namespacePatterns));
        response.getWriter().flush();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    void bindSource(CapabilitiesSource src) {
        this.sources.add(src);
    }

    void unbindSource(CapabilitiesSource src) {
        this.sources.remove(src);
    }

    @ObjectClassDefinition(name="Apache Sling Capabilities Servlet", description="Provides information about Sling capabilities")
    public static @interface Config {
        @AttributeDefinition(name="Resource Path Patterns", description="A set of (java) regular expression patterns that the resource path must match for this servlet to execute")
        public String[] resourcePathPatterns() default {};
    }
}

