/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.capabilities.defaultsources;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import org.apache.sling.capabilities.CapabilitiesSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={CapabilitiesSource.class})
@Designate(ocd=Config.class, factory=true)
public class SlingServletsSource
implements CapabilitiesSource {
    private String namespace;
    private String ldapFilter;
    private BundleContext bundleContext;
    private static final String SLING_SERVLET_PROPERTY_PREFIX = "sling.servlet.";
    public static final String NAMESPACE_PREFIX = "org.apache.sling.servlets.";

    @Activate
    public void activate(Config cfg, ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.namespace = NAMESPACE_PREFIX + cfg.capabilitiesNamespaceSuffix();
        this.ldapFilter = cfg.servletsLdapFilter();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, Object> getCapabilities() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ServiceReference[] refs = this.bundleContext.getServiceReferences(Servlet.class.getName(), this.ldapFilter);
        if (refs != null) {
            for (ServiceReference ref : refs) {
                TreeMap<String, Object> caps = SlingServletsSource.getCapabilities(ref);
                result.put(this.uniqueKey(ref, caps), caps);
            }
        }
        return result;
    }

    private static TreeMap<String, Object> getCapabilities(ServiceReference ref) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String key : ref.getPropertyKeys()) {
            Object value;
            if (!key.startsWith(SLING_SERVLET_PROPERTY_PREFIX) || (value = ref.getProperty(key)) == null) continue;
            result.put(key, SlingServletsSource.maybeConvertToSingleValue(value));
        }
        return result;
    }

    static Object maybeConvertToSingleValue(Object input) {
        Object[] arr;
        Object result = input;
        if (input instanceof Object[] && (arr = (Object[])input).length == 1) {
            result = arr[0];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uniqueKey(ServiceReference ref, TreeMap<String, Object> caps) {
        StringBuilder result = new StringBuilder();
        Object service = this.bundleContext.getService(ref);
        try {
            result.append(service.getClass().getSimpleName());
            result.append("_").append(Integer.toHexString(caps.toString().hashCode()));
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
        return result.toString();
    }

    @ObjectClassDefinition(name="Sling Servlets Capabilities Source", description="Provides information about available Sling Servlets")
    public static @interface Config {
        @AttributeDefinition(name="LDAP filter", description="OSGi LDAP filter to select servlets to consider for the provided capabilites")
        public String servletsLdapFilter() default "";

        @AttributeDefinition(name="Capabilities Namespace Suffix", description="Unique namespace suffix that identifies this set of capabilities. Will be prefixed with 'org.apache.sling.servlets.' to compute the actual capabilities namespace")
        public String capabilitiesNamespaceSuffix();
    }
}

