/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl.def;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.impl.util.ConfigNameUtil;
import org.apache.sling.caconfig.resource.impl.util.PathEliminateDuplicatesIterator;
import org.apache.sling.caconfig.resource.impl.util.PathParentExpandIterator;
import org.apache.sling.caconfig.resource.impl.util.PropertyUtil;
import org.apache.sling.caconfig.resource.spi.CollectionInheritanceDecider;
import org.apache.sling.caconfig.resource.spi.ConfigurationResourceResolvingStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.apache.sling.caconfig.resource.spi.InheritanceDecision;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationResourceResolvingStrategy.class})
@Designate(ocd=Config.class)
public class DefaultConfigurationResourceResolvingStrategy
implements ConfigurationResourceResolvingStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationResourceResolvingStrategy.class);
    private volatile Config config;
    @Reference
    private ContextPathStrategyMultiplexer contextPathStrategy;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.REPLACE)
    private volatile List<CollectionInheritanceDecider> collectionInheritanceDeciders;

    @Activate
    private void activate(Config config) {
        this.config = config;
    }

    @Deactivate
    private void deactivate() {
        this.config = null;
    }

    Iterator<String> getResolvePaths(Resource contentResource, Collection<String> bucketNames) {
        return new IteratorChain(this.findConfigRefs(contentResource, bucketNames), (Iterator)new ArrayIterator((Object)this.config.fallbackPaths()));
    }

    private Iterator<String> findConfigRefs(Resource startResource, Collection<String> bucketNames) {
        FilterIterator contextResources = new FilterIterator(this.contextPathStrategy.findContextResources(startResource), new Predicate(){

            public boolean evaluate(Object object) {
                ContextResource contextResource = (ContextResource)object;
                return StringUtils.isNotBlank((CharSequence)contextResource.getConfigRef());
            }
        });
        Iterator<String> configPaths = new Iterator<String>((Iterator)contextResources, bucketNames){
            private final List<ContextResource> relativePaths = new ArrayList<ContextResource>();
            private String next = this.seek();
            private String useFromRelativePathsWith;
            final /* synthetic */ Iterator val$contextResources;
            final /* synthetic */ Collection val$bucketNames;
            {
                this.val$contextResources = iterator;
                this.val$bucketNames = collection;
            }

            private String seek() {
                String val = null;
                while (val == null && (this.useFromRelativePathsWith != null || this.val$contextResources.hasNext())) {
                    ContextResource contextResource;
                    if (this.useFromRelativePathsWith != null) {
                        contextResource = this.relativePaths.remove(this.relativePaths.size() - 1);
                        val = DefaultConfigurationResourceResolvingStrategy.this.checkPath(contextResource, this.useFromRelativePathsWith + "/" + contextResource.getConfigRef(), this.val$bucketNames);
                        if (val != null) {
                            log.trace("+ Found reference for context path {}: {}", (Object)contextResource.getResource().getPath(), (Object)val);
                        }
                        if (!this.relativePaths.isEmpty()) continue;
                        this.useFromRelativePathsWith = null;
                        continue;
                    }
                    contextResource = (ContextResource)this.val$contextResources.next();
                    val = contextResource.getConfigRef();
                    if (val != null && val.startsWith("/")) {
                        val = DefaultConfigurationResourceResolvingStrategy.this.checkPath(contextResource, val, this.val$bucketNames);
                    }
                    if (val != null) {
                        boolean isAbsolute = val.startsWith("/");
                        if (isAbsolute && !this.relativePaths.isEmpty()) {
                            this.useFromRelativePathsWith = val;
                            val = null;
                        } else if (!isAbsolute) {
                            this.relativePaths.add(0, contextResource);
                            val = null;
                        }
                    }
                    if (val == null) continue;
                    log.trace("+ Found reference for context path {}: {}", (Object)contextResource.getResource().getPath(), (Object)val);
                }
                if (val == null && !this.relativePaths.isEmpty()) {
                    log.error("Relative references not used as no absolute reference was found: {}", this.relativePaths);
                }
                return val;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                String result = this.next;
                this.next = this.seek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new PathEliminateDuplicatesIterator(new PathParentExpandIterator(this.config.configPath(), configPaths));
    }

    private String checkPath(ContextResource contextResource, String ref, Collection<String> bucketNames) {
        ref = ResourceUtil.normalize((String)ref);
        for (String bucketName : bucketNames) {
            String notAllowedPostfix = "/" + bucketName;
            if (ref == null || !ref.endsWith(notAllowedPostfix)) continue;
            log.warn("Ignoring reference to {} from {} - Probably misconfigured as it ends with '{}'", new Object[]{contextResource.getConfigRef(), contextResource.getResource().getPath(), notAllowedPostfix});
            ref = null;
        }
        if (ref != null && !this.isAllowedConfigPath(ref)) {
            log.debug("Ignoring reference to {} from {} - not in allowed paths.", (Object)contextResource.getConfigRef(), (Object)contextResource.getResource().getPath());
            ref = null;
        }
        if (ref != null && this.isFallbackConfigPath(ref)) {
            log.debug("Ignoring reference to {} from {} - already a fallback path.", (Object)contextResource.getConfigRef(), (Object)contextResource.getResource().getPath());
            ref = null;
        }
        return ref;
    }

    private boolean isAllowedConfigPath(String path) {
        return path.startsWith(this.config.configPath() + "/");
    }

    private boolean isFallbackConfigPath(String ref) {
        for (String path : this.config.fallbackPaths()) {
            if (!StringUtils.equals((CharSequence)ref, (CharSequence)path) && !StringUtils.startsWith((CharSequence)ref, (CharSequence)(path + "/"))) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabledAndParamsValid(Resource contentResource, Collection<String> bucketNames, String configName) {
        return this.config.enabled() && contentResource != null && ConfigNameUtil.isValid(bucketNames) && ConfigNameUtil.isValid(configName);
    }

    private String buildResourcePath(String path, String name) {
        return ResourceUtil.normalize((String)(path + "/" + name));
    }

    public Resource getResource(@NotNull Resource contentResource, @NotNull Collection<String> bucketNames, @NotNull String configName) {
        Iterator<Resource> resources = this.getResourceInheritanceChain(contentResource, bucketNames, configName);
        if (resources != null && resources.hasNext()) {
            return resources.next();
        }
        return null;
    }

    private Iterator<Resource> getResourceInheritanceChainInternal(final Collection<String> bucketNames, final String configName, Iterator<String> paths, final ResourceResolver resourceResolver) {
        Iterator matchingResources = IteratorUtils.transformedIterator(paths, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String path = (String)input;
                for (String bucketName : bucketNames) {
                    String name = bucketName + "/" + configName;
                    String configPath = DefaultConfigurationResourceResolvingStrategy.this.buildResourcePath(path, name);
                    Resource resource = resourceResolver.getResource(configPath);
                    if (resource != null) {
                        log.trace("+ Found matching config resource for inheritance chain: {}", (Object)configPath);
                        return resource;
                    }
                    log.trace("- No matching config resource for inheritance chain: {}", (Object)configPath);
                }
                return null;
            }
        });
        Iterator result = IteratorUtils.filteredIterator((Iterator)matchingResources, (Predicate)PredicateUtils.notNullPredicate());
        if (result.hasNext()) {
            return result;
        }
        return null;
    }

    public Iterator<Resource> getResourceInheritanceChain(@NotNull Resource contentResource, @NotNull Collection<String> bucketNames, @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, bucketNames, configName)) {
            return null;
        }
        ResourceResolver resourceResolver = contentResource.getResourceResolver();
        Iterator<String> paths = this.getResolvePaths(contentResource, bucketNames);
        return this.getResourceInheritanceChainInternal(bucketNames, configName, paths, resourceResolver);
    }

    private boolean include(List<CollectionInheritanceDecider> deciders, String bucketName, Resource resource, Set<String> blockedItems) {
        boolean result;
        boolean bl = result = !blockedItems.contains(resource.getName());
        if (result && deciders != null && !deciders.isEmpty()) {
            for (int i = deciders.size() - 1; i >= 0; --i) {
                InheritanceDecision decision = deciders.get(i).decide(resource, bucketName);
                if (decision == InheritanceDecision.EXCLUDE) {
                    log.trace("- Block resource collection inheritance for bucket {}, resource {} because {} retruned EXCLUDE.", new Object[]{bucketName, resource.getPath(), deciders.get(i)});
                    result = false;
                    break;
                }
                if (decision != InheritanceDecision.BLOCK) continue;
                log.trace("- Block resource collection inheritance for bucket {}, resource {} because {} retruned BLOCK.", new Object[]{bucketName, resource.getPath(), deciders.get(i)});
                result = false;
                blockedItems.add(resource.getName());
                break;
            }
        }
        return result;
    }

    private Collection<Resource> getResourceCollectionInternal(Collection<String> bucketNames, String configName, Iterator<String> paths, ResourceResolver resourceResolver) {
        LinkedHashMap<String, Resource> result = new LinkedHashMap<String, Resource>();
        List<CollectionInheritanceDecider> deciders = this.collectionInheritanceDeciders;
        HashSet<String> blockedItems = new HashSet<String>();
        boolean inherit = false;
        while (paths.hasNext()) {
            ValueMap valueMap;
            String path = paths.next();
            Resource item = null;
            String bucketNameUsed = null;
            for (String bucketName : bucketNames) {
                String name = bucketName + "/" + configName;
                String configPath = this.buildResourcePath(path, name);
                item = resourceResolver.getResource(configPath);
                if (item != null) {
                    bucketNameUsed = bucketName;
                    break;
                }
                log.trace("- No collection parent resource found: {}", (Object)configPath);
            }
            if (item == null) continue;
            log.trace("o Check children of collection parent resource: {}", (Object)item.getPath());
            if (item.hasChildren()) {
                for (Resource child : item.getChildren()) {
                    if (!this.isValidResourceCollectionItem(child) || result.containsKey(child.getName()) || !this.include(deciders, bucketNameUsed, child, blockedItems)) continue;
                    log.trace("+ Found collection resource item {}", (Object)child.getPath());
                    result.put(child.getName(), child);
                }
            }
            if (inherit = PropertyUtil.getBooleanValueAdditionalKeys(valueMap = item.getValueMap(), "sling:configCollectionInherit", this.config.configCollectionInheritancePropertyNames())) continue;
            break;
        }
        return result.values();
    }

    public Collection<Resource> getResourceCollection(@NotNull Resource contentResource, @NotNull Collection<String> bucketNames, @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, bucketNames, configName)) {
            return null;
        }
        Iterator<String> paths = this.getResolvePaths(contentResource, bucketNames);
        Collection<Resource> result = this.getResourceCollectionInternal(bucketNames, configName, paths, contentResource.getResourceResolver());
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public Collection<Iterator<Resource>> getResourceCollectionInheritanceChain(@NotNull Resource contentResource, final @NotNull Collection<String> bucketNames, final @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, bucketNames, configName)) {
            return null;
        }
        final ResourceResolver resourceResolver = contentResource.getResourceResolver();
        final List paths = IteratorUtils.toList(this.getResolvePaths(contentResource, bucketNames));
        Collection<Resource> resourceCollection = this.getResourceCollectionInternal(bucketNames, configName, paths.iterator(), resourceResolver);
        Iterator result = IteratorUtils.transformedIterator(resourceCollection.iterator(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                Resource item = (Resource)input;
                return DefaultConfigurationResourceResolvingStrategy.this.getResourceInheritanceChainInternal(bucketNames, configName + "/" + item.getName(), paths.iterator(), resourceResolver);
            }
        });
        if (result.hasNext()) {
            return IteratorUtils.toList((Iterator)result);
        }
        return null;
    }

    private boolean isValidResourceCollectionItem(Resource resource) {
        return !StringUtils.equals((CharSequence)resource.getName(), (CharSequence)"jcr:content");
    }

    public String getResourcePath(@NotNull Resource contentResource, @NotNull String bucketName, @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, Collections.singleton(bucketName), configName)) {
            return null;
        }
        String name = bucketName + "/" + configName;
        Iterator<String> configPaths = this.findConfigRefs(contentResource, Collections.singleton(bucketName));
        if (configPaths.hasNext()) {
            String configPath = this.buildResourcePath(configPaths.next(), name);
            log.trace("+ Building configuration path for name '{}' for resource {}: {}", new Object[]{name, contentResource.getPath(), configPath});
            return configPath;
        }
        log.trace("- No configuration path for name '{}' found for resource {}", (Object)name, (Object)contentResource.getPath());
        return null;
    }

    public String getResourceCollectionParentPath(@NotNull Resource contentResource, @NotNull String bucketName, @NotNull String configName) {
        return this.getResourcePath(contentResource, bucketName, configName);
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Default Resource Resolving Strategy", description="Standardized access to configurations in the resource tree.")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this configuration resource resolving strategy.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Configurations path", description="Paths where the configurations are stored in.")
        public String configPath() default "/conf";

        @AttributeDefinition(name="Fallback paths", description="Global fallback configurations, ordered from most specific (checked first) to least specific.")
        public String[] fallbackPaths() default {"/conf/global", "/apps/conf", "/libs/conf"};

        @AttributeDefinition(name="Config collection inheritance property names", description="Additional property names to sling:configCollectionInherit to handle configuration inheritance. The names are used in the order defined, always starting with sling:configCollectionInherit. Once a property with a value is found, that value is used and the following property names are skipped.")
        public String[] configCollectionInheritancePropertyNames();
    }
}

