/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.impl.PropertiesFilterUtil;
import org.apache.sling.caconfig.management.impl.ValueInfoImpl;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationOverrideMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceStrategy2;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.jetbrains.annotations.NotNull;

final class ConfigurationDataImpl
implements ConfigurationData {
    private final ConfigurationMetadata configMetadata;
    private final Resource resolvedConfigurationResource;
    private final Resource writebackConfigurationResource;
    private final List<Resource> configurationResourceInheritanceChain;
    private final Resource contextResource;
    private final String configName;
    private final ConfigurationManager configurationManager;
    private final ConfigurationManagementSettings configurationManagementSettings;
    private final ConfigurationOverrideMultiplexer configurationOverrideMultiplexer;
    private final ConfigurationPersistenceStrategy2 configurationPersistenceStrategy;
    private final boolean configResourceCollection;
    private final String collectionItemName;
    private final boolean isAllOverridden;
    private Set<String> propertyNamesCache;
    private ValueMap valuesCache;
    private ValueMap effectiveValuesCache;

    public ConfigurationDataImpl(ConfigurationMetadata configMetadata, Resource resolvedConfigurationResource, Resource writebackConfigurationResource, Iterator<Resource> configurationResourceInheritanceChain, Resource contextResource, String configName, ConfigurationManager configurationManager, ConfigurationManagementSettings configurationManagementSettings, ConfigurationOverrideMultiplexer configurationOverrideMultiplexer, ConfigurationPersistenceStrategy2 configurationPersistenceStrategy, boolean configResourceCollection, String collectionItemName) {
        this.configMetadata = configMetadata;
        this.resolvedConfigurationResource = resolvedConfigurationResource;
        this.writebackConfigurationResource = writebackConfigurationResource;
        this.configurationResourceInheritanceChain = configurationResourceInheritanceChain != null ? IteratorUtils.toList(configurationResourceInheritanceChain) : null;
        this.contextResource = contextResource;
        this.configName = configName;
        this.configurationManager = configurationManager;
        this.configurationManagementSettings = configurationManagementSettings;
        this.configurationOverrideMultiplexer = configurationOverrideMultiplexer;
        this.configurationPersistenceStrategy = configurationPersistenceStrategy;
        this.configResourceCollection = configResourceCollection;
        this.collectionItemName = collectionItemName;
        this.isAllOverridden = contextResource != null ? configurationOverrideMultiplexer.isAllOverridden(contextResource.getPath(), configName) : false;
    }

    public ConfigurationDataImpl(ConfigurationMetadata configMetadata, Resource contextResource, String configName, ConfigurationManager configurationManager, ConfigurationManagementSettings configurationManagementSettings, ConfigurationOverrideMultiplexer configurationOverrideMultiplexer, ConfigurationPersistenceStrategy2 configurationPersistenceStrategy, boolean configResourceCollection) {
        this(configMetadata, null, null, null, contextResource, configName, configurationManager, configurationManagementSettings, configurationOverrideMultiplexer, configurationPersistenceStrategy, configResourceCollection, null);
    }

    @Override
    @NotNull
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getCollectionItemName() {
        return this.collectionItemName;
    }

    @Override
    public String getResourcePath() {
        if (this.writebackConfigurationResource != null) {
            return this.writebackConfigurationResource.getPath();
        }
        if (this.resolvedConfigurationResource != null) {
            return this.resolvedConfigurationResource.getPath();
        }
        return null;
    }

    @Override
    @NotNull
    public Set<String> getPropertyNames() {
        if (this.propertyNamesCache == null) {
            this.propertyNamesCache = new LinkedHashSet<String>();
            if (this.configMetadata != null) {
                this.propertyNamesCache.addAll(this.configMetadata.getPropertyMetadata().keySet());
            }
            if (this.resolvedConfigurationResource != null) {
                this.propertyNamesCache.addAll(new TreeSet(ResourceUtil.getValueMap((Resource)this.resolvedConfigurationResource).keySet()));
            }
            PropertiesFilterUtil.removeIgnoredProperties(this.propertyNamesCache, this.configurationManagementSettings);
        }
        return this.propertyNamesCache;
    }

    @Override
    @NotNull
    public ValueMap getValues() {
        if (this.valuesCache == null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (this.writebackConfigurationResource != null) {
                props.putAll((Map<String, Object>)ResourceUtil.getValueMap((Resource)this.writebackConfigurationResource));
            }
            PropertiesFilterUtil.removeIgnoredProperties(props, this.configurationManagementSettings);
            this.resolveNestedConfigs(props);
            this.valuesCache = new ValueMapDecorator(props);
        }
        return this.valuesCache;
    }

    @Override
    @NotNull
    public ValueMap getEffectiveValues() {
        if (this.effectiveValuesCache == null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (this.configMetadata != null) {
                for (PropertyMetadata propertyMetadata : this.configMetadata.getPropertyMetadata().values()) {
                    if (propertyMetadata.getDefaultValue() == null) continue;
                    props.put(propertyMetadata.getName(), propertyMetadata.getDefaultValue());
                }
            }
            if (this.resolvedConfigurationResource != null) {
                props.putAll((Map<String, Object>)ResourceUtil.getValueMap((Resource)this.resolvedConfigurationResource));
            }
            PropertiesFilterUtil.removeIgnoredProperties(props, this.configurationManagementSettings);
            this.resolveNestedConfigs(props);
            this.effectiveValuesCache = new ValueMapDecorator(props);
        }
        return this.effectiveValuesCache;
    }

    private void resolveNestedConfigs(Map<String, Object> props) {
        if (this.configMetadata == null) {
            return;
        }
        for (PropertyMetadata propertyMetadata : this.configMetadata.getPropertyMetadata().values()) {
            String nestedConfigName;
            String relatedConfigPath;
            if (!propertyMetadata.isNestedConfiguration()) continue;
            ConfigurationMetadata nestedConfigMetadata = propertyMetadata.getConfigurationMetadata();
            String string = relatedConfigPath = this.resolvedConfigurationResource != null ? this.resolvedConfigurationResource.getPath() : null;
            if (this.configResourceCollection) {
                String collectionItemName = StringUtils.defaultString((String)this.getCollectionItemName(), (String)"newItem");
                nestedConfigName = this.configurationPersistenceStrategy.getCollectionParentConfigName(this.configName, relatedConfigPath) + "/" + this.configurationPersistenceStrategy.getCollectionItemConfigName(collectionItemName, relatedConfigPath) + "/" + nestedConfigMetadata.getName();
            } else {
                nestedConfigName = this.configurationPersistenceStrategy.getConfigName(this.configName, relatedConfigPath) + "/" + nestedConfigMetadata.getName();
            }
            if (propertyMetadata.getType().equals(ConfigurationMetadata.class)) {
                ConfigurationData configData = this.configurationManager.getConfiguration(this.contextResource, nestedConfigName);
                props.put(propertyMetadata.getName(), configData);
                continue;
            }
            if (!propertyMetadata.getType().equals(ConfigurationMetadata[].class)) continue;
            Collection<ConfigurationData> configDatas = this.configurationManager.getConfigurationCollection(this.contextResource, nestedConfigName).getItems();
            props.put(propertyMetadata.getName(), configDatas.toArray(new ConfigurationData[configDatas.size()]));
        }
    }

    @Override
    public ValueInfo<?> getValueInfo(String propertyName) {
        Object effectiveValue;
        Object value;
        PropertyMetadata<?> propertyMetadata = this.getPropertyMetadata(propertyName);
        if (propertyMetadata != null) {
            Class type = propertyMetadata.getType();
            type = type == ConfigurationMetadata.class ? ConfigurationData.class : (type == ConfigurationMetadata[].class ? ConfigurationData[].class : this.primitiveToWrapper(type));
            value = this.getValues().get(propertyName, type);
            effectiveValue = this.getEffectiveValues().get(propertyName, type);
        } else {
            value = this.getValues().get((Object)propertyName);
            effectiveValue = this.getEffectiveValues().get((Object)propertyName);
        }
        return new ValueInfoImpl<Object>(propertyName, value, effectiveValue, propertyMetadata, this.resolvedConfigurationResource, this.writebackConfigurationResource, this.configurationResourceInheritanceChain, this.contextResource, this.configName, this.configurationOverrideMultiplexer, this.isAllOverridden);
    }

    private Class<?> primitiveToWrapper(Class<?> type) {
        if (type.isArray()) {
            return Array.newInstance(ClassUtils.primitiveToWrapper(type.getComponentType()), 0).getClass();
        }
        return ClassUtils.primitiveToWrapper(type);
    }

    private PropertyMetadata<?> getPropertyMetadata(String propertyName) {
        if (this.configMetadata == null) {
            return null;
        }
        return (PropertyMetadata)this.configMetadata.getPropertyMetadata().get(propertyName);
    }

    @Override
    public boolean isInherited() {
        if (this.resolvedConfigurationResource != null && this.resolvedConfigurationResource.getPath() != null) {
            if (this.writebackConfigurationResource == null) {
                return true;
            }
            return !StringUtils.equals((CharSequence)this.writebackConfigurationResource.getPath(), (CharSequence)this.resolvedConfigurationResource.getPath());
        }
        return false;
    }

    @Override
    public boolean isOverridden() {
        return this.isAllOverridden;
    }
}

