/*
 * Decompiled with CFR 0.152.
 */
package caconfigimpl.org.apache.sling.commons.osgi;

import caconfigimpl.org.apache.sling.commons.osgi.BundleFileProcessor;
import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class BSNRenamer
extends BundleFileProcessor {
    private final String newBSN;
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String X_ORIG_BSN = "X-Original-Bundle-SymbolicName";
    public static final String BUNDLE_VERSION = "Bundle-Version";

    public BSNRenamer(File input, File outputFolder, String newBSN) {
        super(input, outputFolder);
        this.newBSN = newBSN;
    }

    @Override
    protected Manifest processManifest(Manifest inputMF) {
        Attributes inputAttrs = inputMF.getMainAttributes();
        String orgBSN = inputAttrs.getValue(BUNDLE_SYMBOLIC_NAME);
        Manifest newMF = new Manifest(inputMF);
        Attributes outputAttrs = newMF.getMainAttributes();
        outputAttrs.putValue(BUNDLE_SYMBOLIC_NAME, this.newBSN);
        outputAttrs.putValue(X_ORIG_BSN, orgBSN);
        return newMF;
    }

    @Override
    protected String getTargetFilename(Manifest inputJarManifest) {
        String bver = inputJarManifest.getMainAttributes().getValue(BUNDLE_VERSION);
        if (bver == null) {
            bver = "0.0.0";
        }
        return this.newBSN + "-" + bver + ".jar";
    }
}

