/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.servlets;

import java.io.IOException;
import java.io.Writer;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.bgservlets.JobConsole;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/bg/job"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class JobStateChangeServlet
extends SlingAllMethodsServlet {
    public static final String PARAM_STATE = "desiredState";
    @Reference
    private JobConsole jobConsole;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String str = request.getParameter(PARAM_STATE);
        if (str == null) {
            response.sendError(400, "Missing parameter:desiredState");
        }
        JobStatus.State desiredState = JobStatus.State.NEW;
        try {
            desiredState = JobStatus.State.valueOf(str);
        }
        catch (Exception e) {
            response.sendError(400, "Invalid desiredState: " + str);
            return;
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (session == null) {
            response.sendError(500, "ResourceResolver does not adapt to a Session");
            return;
        }
        JobStatus j = this.jobConsole.getJobStatus(session, request.getResource().getPath());
        JobStatus.State oldState = j.getState();
        j.requestStateChange(desiredState);
        JobStatus.State newState = j.getState();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JSONWriter w = new JSONWriter((Writer)response.getWriter());
        try {
            w.object();
            w.key("info").value((Object)"Requested state change");
            w.key(PARAM_STATE).value((Object)desiredState.toString());
            w.key("path").value((Object)j.getPath());
            w.key("currentState").value((Object)newState);
            w.key("stateChanged").value(newState != oldState);
            w.endObject();
        }
        catch (JSONException je) {
            throw new ServletException("JSONException in doPost", (Throwable)je);
        }
    }

    protected void bindJobConsole(JobConsole jobConsole) {
        this.jobConsole = jobConsole;
    }

    protected void unbindJobConsole(JobConsole jobConsole) {
        if (this.jobConsole == jobConsole) {
            this.jobConsole = null;
        }
    }
}

