/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.sling.auth.oauth_client.impl.Converter;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials;
import org.apache.sling.auth.oauth_client.spi.UserInfoProcessor;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UserInfoProcessor.class}, property={"service.ranking:Integer=10"})
@Designate(ocd=Config.class)
public class SlingUserInfoProcessorImpl
implements UserInfoProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SlingUserInfoProcessorImpl.class);
    private final CryptoService cryptoService;
    private final boolean storeAccessToken;
    private final boolean storeRefreshToken;

    @Activate
    public SlingUserInfoProcessorImpl(@Reference(policyOption=ReferencePolicyOption.GREEDY) CryptoService service, Config config) {
        this.cryptoService = service;
        this.storeAccessToken = config.storeAccessToken();
        this.storeRefreshToken = config.storeRefreshToken();
    }

    @Override
    @NotNull
    public OidcAuthCredentials process(@Nullable String stringUserInfo, @NotNull String stringTokenResponse, @NotNull String oidcSubject, @NotNull String idp) {
        TokenResponse tokenResponse = SlingUserInfoProcessorImpl.parseTokenResponse(stringTokenResponse);
        UserInfo userInfo = SlingUserInfoProcessorImpl.parseUserInfo(stringUserInfo);
        OAuthTokens tokens = Converter.toSlingOAuthTokens(tokenResponse.toSuccessResponse().getTokens());
        OidcAuthCredentials credentials = new OidcAuthCredentials(oidcSubject, idp);
        credentials.setAttribute(".token", "");
        if (userInfo != null) {
            logger.debug("Preferred Username: {}", (Object)userInfo.getPreferredUsername());
            logger.debug("Subject: {}", (Object)userInfo.getSubject());
            logger.debug("Email: {}", (Object)userInfo.getEmailAddress());
            logger.debug("Name: {}", (Object)userInfo.getGivenName());
            logger.debug("FamilyName: {}", (Object)userInfo.getFamilyName());
            Object groups = userInfo.toJSONObject().remove((Object)"groups");
            if (groups instanceof JSONArray) {
                JSONArray groupJsonArray = (JSONArray)groups;
                logger.debug("Groups: {}", groups);
                groupJsonArray.forEach(group -> credentials.addGroup(group.toString()));
            }
            userInfo.toJSONObject().forEach((key, value) -> {
                if (value != null) {
                    credentials.setAttribute("profile/" + key, value.toString());
                }
            });
        }
        String accessToken = tokens.accessToken();
        if (this.storeAccessToken && accessToken != null) {
            credentials.setAttribute("access_token", this.cryptoService.encrypt(accessToken));
        } else {
            logger.debug("Access Token is null, omit adding as credentials attribute '{}'", (Object)"access_token");
        }
        String refreshToken = tokens.accessToken();
        if (this.storeRefreshToken && refreshToken != null) {
            credentials.setAttribute("access_token", this.cryptoService.encrypt(refreshToken));
        } else {
            logger.debug("Refresh Token is null, omit adding as credentials attribute '{}'", (Object)"refresh_token");
        }
        return credentials;
    }

    @Nullable
    private static UserInfo parseUserInfo(@Nullable String stringUserInfo) {
        if (stringUserInfo != null) {
            try {
                return UserInfo.parse((String)stringUserInfo);
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse UserInfo in UserInfoProcessor", e);
            }
        }
        return null;
    }

    @NotNull
    private static TokenResponse parseTokenResponse(@NotNull String stringTokenResponse) {
        try {
            JSONObject jsonTokenResponse = (JSONObject)JSONValue.parse((String)stringTokenResponse);
            return TokenResponse.parse((JSONObject)jsonTokenResponse);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse TokenResponse in UserInfoProcessor", e);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Oidc UserInfo Processor", description="Apache Sling Oidc UserInfo Processor Service")
    static @interface Config {
        @AttributeDefinition(name="storeAccessToken", description="Store access Token under User Node")
        public boolean storeAccessToken() default false;

        @AttributeDefinition(name="storeRefreshToken", description="Store access Refresh under User Node")
        public boolean storeRefreshToken() default false;
    }
}

