/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthConnectionImpl;
import org.apache.sling.auth.oauth_client.impl.OidcConnectionImpl;
import org.jetbrains.annotations.NotNull;

public record ResolvedOAuthConnection(String name, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret, List<String> scopes, List<String> additionalAuthorizationParameters) {
    public static ResolvedOAuthConnection resolve(@NotNull ClientConnection connection) {
        if (connection instanceof OidcConnectionImpl) {
            OidcConnectionImpl impl = (OidcConnectionImpl)connection;
            return new ResolvedOAuthConnection(connection.name(), impl.authorizationEndpoint(), impl.tokenEndpoint(), impl.clientId(), impl.clientSecret(), Arrays.asList(impl.scopes()), Arrays.asList(impl.additionalAuthorizationParameters()));
        }
        if (connection instanceof OAuthConnectionImpl) {
            OAuthConnectionImpl impl = (OAuthConnectionImpl)connection;
            return new ResolvedOAuthConnection(connection.name(), impl.authorizationEndpoint(), impl.tokenEndpoint(), impl.clientId(), impl.clientSecret(), Arrays.asList(impl.scopes()), Arrays.asList(impl.additionalAuthorizationParameters()));
        }
        throw new IllegalArgumentException(String.format("Unable to resolve %s (name=%s) of type %s", ClientConnection.class.getSimpleName(), connection.name(), connection.getClass().getName()));
    }
}

