/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthException;
import org.apache.sling.auth.oauth_client.impl.OAuthToken;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenStore;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.TokenState;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class RedisOAuthTokenStore
implements OAuthTokenStore {
    private static final String KEY_PREFIX = "sling.oauth.tokens";
    private static final String KEY_SEGMENT_ACCESS_TOKEN = "access_token";
    private static final String KEY_SEGMENT_REFRESH_TOKEN = "refresh_token";
    private final JedisPool pool;

    @Activate
    public RedisOAuthTokenStore(Config cfg) {
        this.pool = new JedisPool(cfg.redisUrl());
    }

    public void deactivate() {
        this.pool.close();
    }

    @Override
    public OAuthToken getAccessToken(ClientConnection connection, ResourceResolver resolver) throws OAuthException {
        String userId = resolver.getUserID();
        try (Jedis jedis = this.pool.getResource();){
            String accessToken = jedis.get(this.keyFor(userId, connection, KEY_SEGMENT_ACCESS_TOKEN));
            if (accessToken != null) {
                OAuthToken oAuthToken = new OAuthToken(TokenState.VALID, accessToken);
                return oAuthToken;
            }
            String refreshToken = jedis.get(this.keyFor(userId, connection, KEY_SEGMENT_REFRESH_TOKEN));
            if (refreshToken != null) {
                OAuthToken oAuthToken = new OAuthToken(TokenState.EXPIRED, null);
                return oAuthToken;
            }
            OAuthToken oAuthToken = new OAuthToken(TokenState.MISSING, null);
            return oAuthToken;
        }
    }

    @Override
    public OAuthToken getRefreshToken(ClientConnection connection, ResourceResolver resolver) throws OAuthException {
        String userId = resolver.getUserID();
        try (Jedis jedis = this.pool.getResource();){
            String refreshToken = jedis.get(this.keyFor(userId, connection, KEY_SEGMENT_REFRESH_TOKEN));
            if (refreshToken != null) {
                OAuthToken oAuthToken = new OAuthToken(TokenState.VALID, refreshToken);
                return oAuthToken;
            }
            OAuthToken oAuthToken = new OAuthToken(TokenState.MISSING, null);
            return oAuthToken;
        }
    }

    @Override
    public void persistTokens(ClientConnection connection, ResourceResolver resolver, OAuthTokens tokens) throws OAuthException {
        String userId = resolver.getUserID();
        try (Jedis jedis = this.pool.getResource();){
            this.setWithExpiry(jedis, this.keyFor(userId, connection, KEY_SEGMENT_ACCESS_TOKEN), tokens.accessToken(), tokens.expiresAt());
            if (tokens.refreshToken() != null) {
                jedis.set(this.keyFor(userId, connection, KEY_SEGMENT_REFRESH_TOKEN), tokens.refreshToken());
            }
        }
    }

    @Override
    public void clearAccessToken(ClientConnection connection, ResourceResolver resolver) throws OAuthException {
        String userId = resolver.getUserID();
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(this.keyFor(userId, connection, KEY_SEGMENT_ACCESS_TOKEN));
        }
    }

    private void setWithExpiry(Jedis jedis, String key, String value, long expiry) {
        jedis.set(key, value);
        if (expiry > 0L) {
            jedis.expire(key, expiry);
        }
    }

    private String keyFor(String principal, ClientConnection connection, String tokenType) {
        return "sling.oauth.tokens." + principal + "." + connection.name() + "." + tokenType;
    }

    @ObjectClassDefinition(name="Redis OAuth Token Store")
    static @interface Config {
        @AttributeDefinition(name="Redis URL")
        public String redisUrl();
    }
}

