/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.auth.oauth_client.ClientConnection;

public abstract class OAuthUris {
    public static URI getOAuthEntryPointUri(ClientConnection connection, SlingHttpServletRequest request, String redirectPath) {
        boolean needsExplicitPort;
        StringBuilder uri = new StringBuilder();
        uri.append(request.getScheme()).append("://").append(request.getServerName());
        boolean bl = needsExplicitPort = "https".equals(request.getScheme()) && request.getServerPort() != 443 || "http".equals(request.getScheme()) && request.getServerPort() != 80;
        if (needsExplicitPort) {
            uri.append(':').append(request.getServerPort());
        }
        uri.append("/system/sling/oauth/entry-point").append("?c=").append(connection.name());
        if (redirectPath != null) {
            uri.append("&redirect=").append(URLEncoder.encode(redirectPath, StandardCharsets.UTF_8));
        }
        return URI.create(uri.toString());
    }

    private OAuthUris() {
    }
}

