/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.State;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthCallbackServlet;
import org.apache.sling.auth.oauth_client.impl.OAuthEntryPointException;
import org.apache.sling.auth.oauth_client.impl.OAuthState;
import org.apache.sling.auth.oauth_client.impl.OAuthStateManager;
import org.apache.sling.auth.oauth_client.impl.ResolvedOAuthConnection;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.auth.requirements=/system/sling/oauth/entry-point"})
@SlingServletPaths(value={"/system/sling/oauth/entry-point"})
public class OAuthEntryPointServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final int COOKIE_MAX_AGE_SECONDS = 300;
    public static final String PATH = "/system/sling/oauth/entry-point";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<String, ClientConnection> connections;
    private final OAuthStateManager stateManager;

    @Activate
    public OAuthEntryPointServlet(@Reference(policyOption=ReferencePolicyOption.GREEDY) List<ClientConnection> connections, @Reference OAuthStateManager stateManager) {
        this.connections = connections.stream().collect(Collectors.toMap(ClientConnection::name, Function.identity()));
        this.stateManager = stateManager;
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String desiredConnectionName = request.getParameter("c");
            if (desiredConnectionName == null) {
                this.logger.debug("Missing mandatory request parameter 'c'");
                response.sendError(400);
                return;
            }
            ClientConnection connection = this.connections.get(desiredConnectionName);
            if (connection == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Client requested unknown connection '{}'; known: '{}'", (Object)desiredConnectionName, this.connections.keySet());
                }
                response.sendError(400);
                return;
            }
            RedirectTarget redirect = this.getAuthenticationRequestUri(connection, request, URI.create(OAuthCallbackServlet.getCallbackUri((HttpServletRequest)request)));
            response.addCookie(redirect.cookie());
            response.sendRedirect(redirect.uri().toString());
        }
        catch (Exception e) {
            throw new OAuthEntryPointException("Internal error", e);
        }
    }

    private RedirectTarget getAuthenticationRequestUri(ClientConnection connection, SlingHttpServletRequest request, URI redirectUri) {
        ResolvedOAuthConnection conn = ResolvedOAuthConnection.resolve(connection);
        ClientID clientID = new ClientID(conn.clientId());
        String connectionName = connection.name();
        String redirect = request.getParameter("redirect");
        String perRequestKey = new Identifier().getValue();
        Cookie cookie = new Cookie("sling.oauth-request-key", perRequestKey);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setMaxAge(300);
        State state = this.stateManager.toNimbusState(new OAuthState(perRequestKey, connectionName, redirect));
        URI authorizationEndpointUri = URI.create(conn.authorizationEndpoint());
        AuthorizationRequest.Builder authRequestBuilder = new AuthorizationRequest.Builder(ResponseType.CODE, clientID).scope(new Scope(conn.scopes().toArray(new String[0]))).endpointURI(authorizationEndpointUri).redirectionURI(redirectUri).state(state);
        if (conn.additionalAuthorizationParameters() != null) {
            conn.additionalAuthorizationParameters().stream().map(s -> s.split("=")).filter(p -> ((String[])p).length == 2).forEach(p -> authRequestBuilder.customParameter(p[0], new String[]{p[1]}));
        }
        return new RedirectTarget(authRequestBuilder.build().toURI(), cookie);
    }

    record RedirectTarget(URI uri, Cookie cookie) {
    }
}

