/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import org.apache.sling.auth.oauth_client.ClientConnection;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class, factory=true)
public class OAuthConnectionImpl
implements ClientConnection {
    private final Config cfg;

    @Activate
    public OAuthConnectionImpl(Config cfg) {
        this.cfg = cfg;
    }

    @Override
    public String name() {
        return this.cfg.name();
    }

    public String authorizationEndpoint() {
        return this.cfg.authorizationEndpoint();
    }

    public String tokenEndpoint() {
        return this.cfg.tokenEndpoint();
    }

    public String clientId() {
        return this.cfg.clientId();
    }

    public String clientSecret() {
        return this.cfg.clientSecret();
    }

    public String[] scopes() {
        return this.cfg.scopes();
    }

    public String[] additionalAuthorizationParameters() {
        return this.cfg.additionalAuthorizationParameters();
    }

    @ObjectClassDefinition(name="OAuth connection details")
    public static @interface Config {
        public String name();

        public String authorizationEndpoint();

        public String tokenEndpoint();

        public String clientId();

        @AttributeDefinition(type=AttributeType.PASSWORD)
        public String clientSecret();

        public String[] scopes();

        public String[] additionalAuthorizationParameters();

        public String webconsole_configurationFactory_nameHint() default "Name: {name}, auth endpoint: {authorizationEndpoint}, clientId: {clientId}";
    }
}

