/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthException;
import org.apache.sling.auth.oauth_client.impl.OAuthToken;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenStore;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.TokenState;
import org.apache.sling.commons.crypto.CryptoService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
public class JcrUserHomeOAuthTokenStore
implements OAuthTokenStore {
    private static final String PROPERTY_NAME_EXPIRES_AT = "expires_at";
    private static final String PROPERTY_NAME_ACCESS_TOKEN = "access_token";
    private static final String PROPERTY_NAME_REFRESH_TOKEN = "refresh_token";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CryptoService cryptoService;

    @Activate
    public JcrUserHomeOAuthTokenStore(@Reference(target="(names=sling-oauth)") CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Override
    public OAuthToken getAccessToken(ClientConnection connection, ResourceResolver resolver) {
        try {
            Calendar expiresCal;
            User user = (User)resolver.adaptTo(User.class);
            Value[] expiresAt = user.getProperty(this.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT));
            if (expiresAt != null && expiresAt.length == 1 && expiresAt[0].getType() == 5 && (expiresCal = expiresAt[0].getDate()).before(Calendar.getInstance())) {
                this.logger.info("Token for {} expired at {}, marking as expired", (Object)connection.name(), (Object)expiresCal);
                return new OAuthToken(TokenState.EXPIRED, null);
            }
            return this.getToken(connection, user, PROPERTY_NAME_ACCESS_TOKEN);
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    private OAuthToken getToken(ClientConnection connection, User user, String propertyName) throws RepositoryException {
        Value[] tokenValue = user.getProperty(this.propertyPath(connection, propertyName));
        if (tokenValue == null) {
            return new OAuthToken(TokenState.MISSING, null);
        }
        if (tokenValue.length != 1) {
            throw new OAuthException(String.format("Unexpected value count %d for token property %s", tokenValue.length, propertyName));
        }
        String encryptedValue = tokenValue[0].getString();
        return new OAuthToken(TokenState.VALID, this.cryptoService.decrypt(encryptedValue));
    }

    @Override
    public OAuthToken getRefreshToken(ClientConnection connection, ResourceResolver resolver) {
        try {
            User user = (User)resolver.adaptTo(User.class);
            return this.getToken(connection, user, PROPERTY_NAME_REFRESH_TOKEN);
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    @Override
    public void persistTokens(ClientConnection connection, ResourceResolver resolver, OAuthTokens tokens) {
        try {
            User currentUser = (User)resolver.adaptTo(User.class);
            Session session = (Session)resolver.adaptTo(Session.class);
            ZonedDateTime expiry = null;
            long expiresAt = tokens.expiresAt();
            if (expiresAt > 0L) {
                expiry = ZonedDateTime.now().plusSeconds(expiresAt);
            }
            currentUser.setProperty(this.propertyPath(connection, PROPERTY_NAME_ACCESS_TOKEN), this.createTokenValue(session, tokens.accessToken()));
            if (expiry != null) {
                GregorianCalendar cal = GregorianCalendar.from(expiry);
                currentUser.setProperty(this.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT), session.getValueFactory().createValue((Calendar)cal));
            } else {
                currentUser.removeProperty(this.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT));
            }
            if (tokens.refreshToken() != null) {
                String refreshToken = tokens.refreshToken();
                if (refreshToken != null) {
                    currentUser.setProperty(this.propertyPath(connection, PROPERTY_NAME_REFRESH_TOKEN), this.createTokenValue(session, refreshToken));
                } else {
                    currentUser.removeProperty(this.propertyPath(connection, PROPERTY_NAME_REFRESH_TOKEN));
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    private Value createTokenValue(Session session, String propertyValue) throws RepositoryException {
        String encryptedValue = this.cryptoService.encrypt(propertyValue);
        return session.getValueFactory().createValue(encryptedValue);
    }

    private String propertyPath(ClientConnection connection, String propertyName) {
        return this.nodePath(connection) + "/" + propertyName;
    }

    private String nodePath(ClientConnection connection) {
        return "oauth-tokens/" + connection.name();
    }

    @Override
    public void clearAccessToken(ClientConnection connection, ResourceResolver resolver) throws OAuthException {
        try {
            User currentUser = (User)resolver.adaptTo(User.class);
            Session session = (Session)resolver.adaptTo(Session.class);
            currentUser.removeProperty(this.propertyPath(connection, PROPERTY_NAME_ACCESS_TOKEN));
            currentUser.removeProperty(this.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT));
            session.save();
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }
}

