/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.id.State;
import java.util.Optional;
import org.apache.sling.auth.oauth_client.impl.OAuthState;
import org.apache.sling.auth.oauth_client.impl.OAuthStateManager;
import org.apache.sling.commons.crypto.CryptoService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class CryptoOAuthStateManager
implements OAuthStateManager {
    private static final Logger logger = LoggerFactory.getLogger(CryptoOAuthStateManager.class);
    private final CryptoService cryptoService;

    @Activate
    public CryptoOAuthStateManager(@Reference(target="(names=sling-oauth)") CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Override
    public State toNimbusState(OAuthState state) {
        String rawState = state.perRequestKey() + "|" + state.connectionName();
        if (state.redirect() != null) {
            rawState = rawState + "|" + state.redirect();
        }
        return new State(this.cryptoService.encrypt(rawState));
    }

    @Override
    public Optional<OAuthState> toOAuthState(State state) {
        if (state == null) {
            return Optional.empty();
        }
        try {
            String encrypted = state.getValue();
            String rawState = this.cryptoService.decrypt(encrypted);
            String[] parts = rawState.split("\\|");
            if (parts.length == 2) {
                return Optional.of(new OAuthState(parts[0], parts[1], null));
            }
            if (parts.length == 3) {
                return Optional.of(new OAuthState(parts[0], parts[1], parts[2]));
            }
            logger.warn("Decoded state token does not contain the expected number of parts");
            return Optional.empty();
        }
        catch (RuntimeException e) {
            logger.warn("Failed to decode state token", (Throwable)e);
            return Optional.empty();
        }
    }
}

