/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.OidcTokens;

public class Converter {
    public static OIDCTokens toNimbusOidcTokens(OidcTokens tokens) {
        RefreshToken nimbusRefreshToken = tokens.refreshToken() != null ? new RefreshToken(tokens.refreshToken()) : null;
        BearerAccessToken nimbusAccessToken = new BearerAccessToken(tokens.accessToken(), tokens.expiresAt(), null);
        OIDCTokens nimbusTokens = tokens.idToken() != null ? new OIDCTokens(tokens.idToken(), (AccessToken)nimbusAccessToken, nimbusRefreshToken) : new OIDCTokens((AccessToken)nimbusAccessToken, nimbusRefreshToken);
        return nimbusTokens;
    }

    public static OidcTokens toApiOidcTokens(OIDCTokens nimbusTokens) {
        String accessToken = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getValue() : null;
        long expiresAt = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getLifetime() : 0L;
        String refreshToken = nimbusTokens.getRefreshToken() != null ? nimbusTokens.getRefreshToken().getValue() : null;
        String idToken = nimbusTokens.getIDTokenString();
        return new OidcTokens(accessToken, expiresAt, refreshToken, idToken);
    }

    public static OAuthTokens toSlingOAuthTokens(OIDCTokens nimbusTokens) {
        String accessToken = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getValue() : null;
        long expiresAt = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getLifetime() : 0L;
        String refreshToken = nimbusTokens.getRefreshToken() != null ? nimbusTokens.getRefreshToken().getValue() : null;
        return new OAuthTokens(accessToken, expiresAt, refreshToken);
    }

    public static OAuthTokens toSlingOAuthTokens(Tokens oAuthTokens) {
        String accessToken = oAuthTokens.getAccessToken() != null ? oAuthTokens.getAccessToken().getValue() : null;
        long expiresAt = oAuthTokens.getAccessToken() != null ? oAuthTokens.getAccessToken().getLifetime() : 0L;
        String refreshToken = oAuthTokens.getRefreshToken() != null ? oAuthTokens.getRefreshToken().getValue() : null;
        return new OAuthTokens(accessToken, expiresAt, refreshToken);
    }

    private Converter() {
    }
}

