/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.form.impl;

import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.security.auth.callback.CallbackHandler;
import org.apache.sling.auth.form.impl.FormAuthenticationHandler;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class FormLoginModulePlugin
implements LoginModulePlugin {
    private final FormAuthenticationHandler authHandler;

    static ServiceRegistration register(FormAuthenticationHandler authHandler, BundleContext bundleContext) {
        FormLoginModulePlugin plugin = new FormLoginModulePlugin(authHandler);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.description", "LoginModulePlugin Support for FormAuthenticationHandler");
        properties.put("service.vendor", (String)bundleContext.getBundle().getHeaders().get("Bundle-Vendor"));
        return bundleContext.registerService(LoginModulePlugin.class.getName(), (Object)plugin, properties);
    }

    private FormLoginModulePlugin(FormAuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    public boolean canHandle(Credentials credentials) {
        return this.authHandler.hasAuthData(credentials);
    }

    public void doInit(CallbackHandler callbackHandler, Session session, Map options) {
    }

    public Principal getPrincipal(Credentials credentials) {
        return null;
    }

    public void addPrincipals(Set principals) {
    }

    public AuthenticationPlugin getAuthentication(Principal principal, Credentials creds) {
        return new AuthenticationPlugin(){

            public boolean authenticate(Credentials credentials) {
                return FormLoginModulePlugin.this.authHandler.isValid(credentials);
            }
        };
    }

    public int impersonate(Principal principal, Credentials credentials) {
        return 0;
    }
}

