/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.auth.Authenticator;
import org.apache.sling.api.auth.NoAuthenticationHandlerException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.auth.core.impl.AbstractAuthenticationHandlerHolder;
import org.apache.sling.auth.core.impl.AuthenticationHandlerHolder;
import org.apache.sling.auth.core.impl.AuthenticationRequirementHolder;
import org.apache.sling.auth.core.impl.AuthenticatorWebConsolePlugin;
import org.apache.sling.auth.core.impl.HttpBasicAuthenticationHandler;
import org.apache.sling.auth.core.impl.PathBasedHolderCache;
import org.apache.sling.auth.core.impl.SlingAuthenticatorServiceListener;
import org.apache.sling.auth.core.impl.engine.EngineAuthenticationHandlerHolder;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.AuthenticationInfoPostProcessor;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardListener;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.osgi.util.converter.Converters;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.engine.impl.auth.SlingAuthenticator", service={Authenticator.class, AuthenticationSupport.class, ServletRequestListener.class})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=*)")
@HttpWhiteboardListener
@ServiceDescription(value="Apache Sling Request Authenticator")
@ServiceVendor(value="The Apache Software Foundation")
@Designate(ocd=Config.class)
public class SlingAuthenticator
implements Authenticator,
AuthenticationSupport,
ServletRequestListener {
    private final Logger log = LoggerFactory.getLogger(SlingAuthenticator.class);
    private static final String HTTP_AUTH_ENABLED = "enabled";
    private static final String HTTP_AUTH_DISABLED = "disabled";
    private static final String HTTP_AUTH_PREEMPTIVE = "preemptive";
    private static final String DEFAULT_AUTH_URI_SUFFIX = "/j_security_check";
    private static final String PAR_NEW_PASSWORD = "j_newpassword";
    private static final String AUTH_INFO_PROP_FEEDBACK_HANDLER = "$$sling.auth.AuthenticationFeedbackHandler$$";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private PathBasedHolderCache<AbstractAuthenticationHandlerHolder> authHandlerCache = new PathBasedHolderCache();
    private final PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache = new PathBasedHolderCache();
    private String sudoParameterName;
    private String sudoCookieName;
    private boolean cacheControl;
    private String[] authUriSuffices;
    private String anonUser;
    private char[] anonPassword;
    private HttpBasicAuthenticationHandler httpBasicHandler;
    private ServiceRegistration<Servlet> webConsolePlugin;
    private SlingAuthenticatorServiceListener serviceListener;
    private ServiceTracker authHandlerTracker;
    private ServiceTracker engineAuthHandlerTracker;
    private ServiceTracker<AuthenticationInfoPostProcessor, AuthenticationInfoPostProcessor> authInfoPostProcessorTracker;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile EventAdmin eventAdmin;

    @Activate
    private void activate(BundleContext bundleContext, Config config) {
        this.modified(config);
        AuthenticatorWebConsolePlugin plugin = new AuthenticatorWebConsolePlugin(this);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("felix.webconsole.label", plugin.getLabel());
        props.put("felix.webconsole.title", plugin.getTitle());
        props.put("felix.webconsole.category", "Sling");
        props.put("service.description", "Sling Request Authenticator WebConsole Plugin");
        props.put("service.vendor", "The Apache Software Foundation");
        this.webConsolePlugin = bundleContext.registerService(Servlet.class, (Object)plugin, props);
        this.serviceListener = SlingAuthenticatorServiceListener.createListener(bundleContext, Executors.newSingleThreadExecutor(), this.resourceResolverFactory, this.authRequiredCache);
        this.authHandlerTracker = new AuthenticationHandlerTracker(bundleContext, this.authHandlerCache);
        this.engineAuthHandlerTracker = new EngineAuthenticationHandlerTracker(bundleContext, this.authHandlerCache);
        this.authInfoPostProcessorTracker = new ServiceTracker(bundleContext, AuthenticationInfoPostProcessor.class, null);
        this.authInfoPostProcessorTracker.open();
    }

    @Modified
    private void modified(Config config) {
        String http;
        String anonUser;
        String newPar;
        String newCookie = config.auth_sudo_cookie();
        if (!newCookie.equals(this.sudoCookieName)) {
            this.log.info("modified: Setting new cookie name for impersonation {} (was {})", (Object)newCookie, (Object)this.sudoCookieName);
            this.sudoCookieName = newCookie;
        }
        if (!(newPar = config.auth_sudo_parameter()).equals(this.sudoParameterName)) {
            this.log.info("modified: Setting new parameter name for impersonation {} (was {})", (Object)newPar, (Object)this.sudoParameterName);
            this.sudoParameterName = newPar;
        }
        this.authRequiredCache.clear();
        boolean anonAllowed = config.auth_annonymous();
        this.authRequiredCache.addHolder(new AuthenticationRequirementHolder("/", !anonAllowed, null));
        String[] authReqs = config.sling_auth_requirements();
        if (authReqs != null) {
            for (String authReq : authReqs) {
                if (authReq == null || authReq.length() <= 0) continue;
                this.authRequiredCache.addHolder(AuthenticationRequirementHolder.fromConfig(authReq, null));
            }
        }
        if ((anonUser = config.sling_auth_anonymous_user()) != null && anonUser.length() > 0) {
            this.anonUser = anonUser;
            this.anonPassword = config.sling_auth_anonymous_password() == null ? "".toCharArray() : config.sling_auth_anonymous_password().toCharArray();
        } else {
            this.anonUser = null;
            this.anonPassword = null;
        }
        this.authUriSuffices = config.auth_uri_suffix();
        this.authRequiredCache.addHolder(new AuthenticationRequirementHolder("/system/sling/login", false, null));
        this.authRequiredCache.addHolder(new AuthenticationRequirementHolder("/system/sling/logout", false, null));
        if (this.serviceListener != null) {
            this.serviceListener.registerAllServices();
        }
        if (anonAllowed) {
            http = config.auth_http();
        } else {
            http = HTTP_AUTH_ENABLED;
            this.log.debug("modified: Anonymous Access is denied thus HTTP Basic Authentication is fully enabled");
        }
        if (HTTP_AUTH_DISABLED.equals(http)) {
            this.httpBasicHandler = null;
        } else {
            String realm = config.auth_http_realm();
            this.httpBasicHandler = new HttpBasicAuthenticationHandler(realm, HTTP_AUTH_ENABLED.equals(http));
        }
    }

    @Deactivate
    private void deactivate(BundleContext bundleContext) {
        this.authRequiredCache.clear();
        if (this.engineAuthHandlerTracker != null) {
            this.engineAuthHandlerTracker.close();
            this.engineAuthHandlerTracker = null;
        }
        if (this.authHandlerTracker != null) {
            this.authHandlerTracker.close();
            this.authHandlerTracker = null;
        }
        if (this.serviceListener != null) {
            this.serviceListener.stop(bundleContext);
            this.serviceListener = null;
        }
        if (this.webConsolePlugin != null) {
            this.webConsolePlugin.unregister();
            this.webConsolePlugin = null;
        }
    }

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        boolean process;
        Object sessionAttr = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        if (sessionAttr instanceof ResourceResolver) {
            this.log.debug("handleSecurity: Request already authenticated, nothing to do");
            return true;
        }
        if (sessionAttr != null) {
            this.log.warn("handleSecurity: Overwriting existing ResourceResolver attribute ({})", sessionAttr);
            request.removeAttribute("org.apache.sling.auth.core.ResourceResolver");
        }
        if ((process = this.doHandleSecurity(request, response)) && this.expectAuthenticationHandler(request)) {
            this.log.warn("handleSecurity: AuthenticationHandler did not block request; access denied");
            request.removeAttribute("j_reason");
            request.removeAttribute("j_reason_code");
            AuthUtil.sendInvalid(request, response);
            return false;
        }
        return process;
    }

    private boolean doHandleSecurity(HttpServletRequest request, HttpServletResponse response) {
        Object authUriSufficesAttr = request.getAttribute("org.apache.sling.api.include.auth_uri_suffix");
        if (authUriSufficesAttr == null && this.authUriSuffices != null) {
            request.setAttribute("org.apache.sling.api.include.auth_uri_suffix", (Object)this.authUriSuffices);
        }
        AuthenticationInfo authInfo = this.getAuthenticationInfo(request, response);
        try {
            this.postProcess(authInfo, request, response);
        }
        catch (LoginException e) {
            this.postLoginFailedEvent(request, authInfo, (Exception)((Object)e));
            this.handleLoginFailure(request, response, authInfo, (Exception)((Object)e));
            return false;
        }
        if (authInfo == AuthenticationInfo.DOING_AUTH) {
            this.log.debug("doHandleSecurity: ongoing authentication in the handler");
            return false;
        }
        if (authInfo == AuthenticationInfo.FAIL_AUTH) {
            this.log.debug("doHandleSecurity: Credentials present but not valid, request authentication again");
            AuthUtil.setLoginResourceAttribute(request, request.getRequestURI());
            this.doLogin(request, response);
            return false;
        }
        if (authInfo.getAuthType() == null) {
            this.log.debug("doHandleSecurity: No credentials in the request, anonymous");
            return this.getAnonymousResolver(request, response, authInfo);
        }
        this.log.debug("doHandleSecurity: Trying to get a session for {}", (Object)authInfo.getUser());
        return this.getResolver(request, response, authInfo);
    }

    public void login(HttpServletRequest request, HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        Collection<AbstractAuthenticationHandlerHolder>[] holdersArray = this.authHandlerCache.findApplicableHolders(request);
        String path = this.getHandlerSelectionPath(request);
        boolean done = false;
        block2: for (int m = 0; !done && m < holdersArray.length; ++m) {
            Collection<AbstractAuthenticationHandlerHolder> holderList = holdersArray[m];
            if (holderList == null) continue;
            for (AbstractAuthenticationHandlerHolder holder : holderList) {
                if (!this.isNodeRequiresAuthHandler(path, holder.path)) continue;
                this.log.debug("login: requesting authentication using handler: {}", (Object)holder);
                try {
                    done = holder.requestCredentials(request, response);
                }
                catch (IOException ioe) {
                    this.log.error("login: Failed sending authentication request through handler " + holder + ", access forbidden", (Throwable)ioe);
                    done = true;
                }
                if (!done) continue;
                continue block2;
            }
        }
        if (!done && this.httpBasicHandler != null) {
            done = this.httpBasicHandler.requestCredentials(request, response);
        }
        if (!done) {
            int size = 0;
            for (int m = 0; m < holdersArray.length; ++m) {
                if (holdersArray[m] == null) continue;
                size += holdersArray[m].size();
            }
            this.log.info("login: No handler for request ({} handlers available)", (Object)size);
            throw new NoAuthenticationHandlerException();
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.setSudoCookie(request, response, new AuthenticationInfo("dummy", request.getRemoteUser()));
        String path = this.getHandlerSelectionPath(request);
        Collection<AbstractAuthenticationHandlerHolder>[] holdersArray = this.authHandlerCache.findApplicableHolders(request);
        for (int m = 0; m < holdersArray.length; ++m) {
            Collection<AbstractAuthenticationHandlerHolder> holderSet = holdersArray[m];
            if (holderSet == null) continue;
            for (AbstractAuthenticationHandlerHolder holder : holderSet) {
                if (!this.isNodeRequiresAuthHandler(path, holder.path)) continue;
                this.log.debug("logout: dropping authentication using handler: {}", (Object)holder);
                try {
                    holder.dropCredentials(request, response);
                }
                catch (IOException ioe) {
                    this.log.error("logout: Failed dropping authentication through handler " + holder, (Throwable)ioe);
                }
            }
        }
        if (this.httpBasicHandler != null) {
            this.httpBasicHandler.dropCredentials(request, response);
        }
        this.redirectAfterLogout(request, response);
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletRequest request = sre.getServletRequest();
        Object resolverAttr = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        if (resolverAttr instanceof ResourceResolver) {
            ((ResourceResolver)resolverAttr).close();
            request.removeAttribute("org.apache.sling.auth.core.ResourceResolver");
        }
    }

    Map<String, List<String>> getAuthenticationHandler() {
        List<AbstractAuthenticationHandlerHolder> registeredHolders = this.authHandlerCache.getHolders();
        LinkedHashMap<String, List<String>> handlerMap = new LinkedHashMap<String, List<String>>();
        for (AbstractAuthenticationHandlerHolder holder : registeredHolders) {
            List<String> provider = handlerMap.get(holder.fullPath);
            if (provider == null) {
                provider = new ArrayList<String>();
                handlerMap.put(holder.fullPath, provider);
            }
            provider.add(holder.getProvider());
        }
        if (this.httpBasicHandler != null) {
            List<String> provider = handlerMap.get("/");
            if (provider == null) {
                provider = new ArrayList<String>();
                handlerMap.put("/", provider);
            }
            provider.add(this.httpBasicHandler.toString());
        }
        return handlerMap;
    }

    List<AuthenticationRequirementHolder> getAuthenticationRequirements() {
        return this.authRequiredCache.getHolders();
    }

    String getAnonUserName() {
        return this.anonUser;
    }

    String getSudoCookieName() {
        return this.sudoCookieName;
    }

    String getSudoParameterName() {
        return this.sudoParameterName;
    }

    private String getPath(HttpServletRequest request) {
        String path;
        StringBuilder sb = new StringBuilder();
        if (request.getServletPath() != null) {
            sb.append(request.getServletPath());
        }
        if (request.getPathInfo() != null) {
            sb.append(request.getPathInfo());
        }
        if ((path = sb.toString()).length() == 0) {
            path = "/";
        }
        return path;
    }

    private AuthenticationInfo getAuthenticationInfo(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo authInfo;
        String path = this.getPath(request);
        Collection<AbstractAuthenticationHandlerHolder>[] localArray = this.authHandlerCache.findApplicableHolders(request);
        for (int m = 0; m < localArray.length; ++m) {
            Collection<AbstractAuthenticationHandlerHolder> local = localArray[m];
            if (local == null) continue;
            for (AbstractAuthenticationHandlerHolder holder : local) {
                AuthenticationInfo authInfo2;
                if (!this.isNodeRequiresAuthHandler(path, holder.path) || (authInfo2 = holder.extractCredentials(request, response)) == null) continue;
                authInfo2.put(AUTH_INFO_PROP_FEEDBACK_HANDLER, (Object)holder.getFeedbackHandler());
                return authInfo2;
            }
        }
        if (this.httpBasicHandler != null && (authInfo = this.httpBasicHandler.extractCredentials(request, response)) != null) {
            authInfo.put(AUTH_INFO_PROP_FEEDBACK_HANDLER, (Object)this.httpBasicHandler);
            return authInfo;
        }
        this.log.debug("getAuthenticationInfo: no handler could extract credentials; assuming anonymous");
        return this.getAnonymousCredentials();
    }

    private void postProcess(AuthenticationInfo info, HttpServletRequest request, HttpServletResponse response) throws LoginException {
        Object[] services = this.authInfoPostProcessorTracker.getServices();
        if (services != null) {
            for (Object serviceObj : services) {
                ((AuthenticationInfoPostProcessor)serviceObj).postProcess(info, request, response);
            }
        }
    }

    private boolean getResolver(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        AuthenticationFeedbackHandler feedbackHandler = (AuthenticationFeedbackHandler)authInfo.remove(AUTH_INFO_PROP_FEEDBACK_HANDLER);
        Object sendLoginEvent = authInfo.remove("$$auth.info.login$$");
        try {
            this.handleImpersonation(request, authInfo);
            this.handlePasswordChange(request, authInfo);
            ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver((Map)authInfo);
            boolean impersChanged = this.setSudoCookie(request, response, authInfo);
            if (sendLoginEvent != null) {
                this.postLoginEvent(authInfo);
            }
            request.setAttribute("org.apache.sling.auth.core.ResourceResolver", (Object)resolver);
            boolean processRequest = true;
            if (feedbackHandler != null) {
                boolean bl = processRequest = !feedbackHandler.authenticationSucceeded(request, response, authInfo);
            }
            if (processRequest) {
                if (AuthUtil.isValidateRequest(request)) {
                    AuthUtil.sendValid(response);
                    processRequest = false;
                } else if (impersChanged || feedbackHandler == null) {
                    boolean bl = processRequest = !DefaultAuthenticationFeedbackHandler.handleRedirect(request, response);
                }
            }
            if (processRequest) {
                this.setAttributes(resolver, authInfo.getAuthType(), request);
            } else {
                resolver.close();
            }
            return processRequest;
        }
        catch (LoginException re) {
            this.postLoginFailedEvent(request, authInfo, (Exception)((Object)re));
            if (feedbackHandler != null) {
                feedbackHandler.authenticationFailed(request, response, authInfo);
            }
            if (!response.isCommitted()) {
                return this.handleLoginFailure(request, response, authInfo, (Exception)((Object)re));
            }
            return false;
        }
    }

    private boolean expectAuthenticationHandler(HttpServletRequest request) {
        if (this.authUriSuffices != null) {
            String requestUri = request.getRequestURI();
            for (String uriSuffix : this.authUriSuffices) {
                if (!requestUri.endsWith(uriSuffix)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getAnonymousResolver(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        if (this.isAnonAllowed(request)) {
            try {
                ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver((Map)authInfo);
                if (DefaultAuthenticationFeedbackHandler.handleRedirect(request, response)) {
                    resolver.close();
                    return false;
                }
                this.setAttributes(resolver, null, request);
                return true;
            }
            catch (LoginException re) {
                this.handleLoginFailure(request, response, new AuthenticationInfo(null, "anonymous user"), (Exception)((Object)re));
                return false;
            }
        }
        this.log.info("getAnonymousResolver: Anonymous access not allowed by configuration - requesting credentials");
        this.doLogin(request, response);
        return false;
    }

    private boolean isAnonAllowed(HttpServletRequest request) {
        String path = this.getPath(request);
        Collection<AuthenticationRequirementHolder>[] holderSetArray = this.authRequiredCache.findApplicableHolders(request);
        for (int m = 0; m < holderSetArray.length; ++m) {
            Collection<AuthenticationRequirementHolder> holders = holderSetArray[m];
            if (holders == null) continue;
            for (AuthenticationRequirementHolder holder : holders) {
                if (!this.isNodeRequiresAuthHandler(path, holder.path)) continue;
                return !holder.requiresAuthentication();
            }
        }
        return false;
    }

    private boolean isNodeRequiresAuthHandler(String path, String holderPath) {
        if ("/".equals(holderPath)) {
            return true;
        }
        int holderPathLength = holderPath.length();
        if (path.length() < holderPathLength) {
            return false;
        }
        if (path.equals(holderPath)) {
            return true;
        }
        return path.startsWith(holderPath) && (path.charAt(holderPathLength) == '/' || path.charAt(holderPathLength) == '.');
    }

    private AuthenticationInfo getAnonymousCredentials() {
        AuthenticationInfo info = new AuthenticationInfo(null);
        if (this.anonUser != null) {
            info.setUser(this.anonUser);
            info.setPassword(this.anonPassword);
        }
        return info;
    }

    private boolean handleLoginFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo, Exception reason) {
        String user = authInfo.getUser();
        boolean processRequest = false;
        if (reason.getClass().getName().contains("TooManySessionsException")) {
            this.log.info("handleLoginFailure: Too many sessions for {}: {}", (Object)user, (Object)reason.getMessage());
            try {
                response.sendError(503, "SlingAuthenticator: Too Many Users");
            }
            catch (IOException ioe) {
                this.log.error("handleLoginFailure: Cannot send status 503 to client", (Throwable)ioe);
            }
        } else if (reason instanceof LoginException) {
            this.log.info("handleLoginFailure: Unable to authenticate {}: {}", (Object)user, (Object)reason.getMessage());
            if (this.isAnonAllowed(request) && !this.expectAuthenticationHandler(request) && !AuthUtil.isValidateRequest(request)) {
                this.log.debug("handleLoginFailure: LoginException on an anonymous resource, fallback to getAnonymousResolver");
                processRequest = this.getAnonymousResolver(request, response, new AuthenticationInfo(null));
            } else {
                AuthenticationHandler.FAILURE_REASON_CODES code = this.getFailureReasonFromException(authInfo, reason);
                String message = null;
                switch (code) {
                    case ACCOUNT_LOCKED: {
                        message = "Account is locked";
                        break;
                    }
                    case ACCOUNT_NOT_FOUND: {
                        message = "Account was not found";
                        break;
                    }
                    case PASSWORD_EXPIRED: {
                        message = "Password expired";
                        break;
                    }
                    case PASSWORD_EXPIRED_AND_NEW_PASSWORD_IN_HISTORY: {
                        message = "Password expired and new password found in password history";
                        break;
                    }
                    default: {
                        message = "User name and password do not match";
                    }
                }
                request.setAttribute("j_reason_code", (Object)code);
                this.ensureAttribute(request, "j_reason", message);
                this.doLogin(request, response);
            }
        } else {
            this.log.error("handleLoginFailure: Unable to authenticate " + user, (Throwable)reason);
            try {
                response.sendError(500, "SlingAuthenticator: data access error, reason=" + reason.getClass().getSimpleName());
            }
            catch (IOException ioe) {
                this.log.error("handleLoginFailure: Cannot send status 500 to client", (Throwable)ioe);
            }
        }
        return processRequest;
    }

    private AuthenticationHandler.FAILURE_REASON_CODES getFailureReasonFromException(AuthenticationInfo authInfo, Exception reason) {
        AuthenticationHandler.FAILURE_REASON_CODES code = null;
        if (reason.getClass().getName().contains("TooManySessionsException")) {
            code = null;
        } else if (reason instanceof LoginException) {
            if (reason.getCause() instanceof CredentialExpiredException) {
                Object creds = authInfo.get("user.jcr.credentials");
                code = creds instanceof SimpleCredentials && ((SimpleCredentials)creds).getAttribute("PasswordHistoryException") != null ? AuthenticationHandler.FAILURE_REASON_CODES.PASSWORD_EXPIRED_AND_NEW_PASSWORD_IN_HISTORY : AuthenticationHandler.FAILURE_REASON_CODES.PASSWORD_EXPIRED;
            } else if (reason.getCause() instanceof AccountLockedException) {
                code = AuthenticationHandler.FAILURE_REASON_CODES.ACCOUNT_LOCKED;
            } else if (reason.getCause() instanceof AccountNotFoundException) {
                code = AuthenticationHandler.FAILURE_REASON_CODES.ACCOUNT_NOT_FOUND;
            }
            if (code == null) {
                code = AuthenticationHandler.FAILURE_REASON_CODES.INVALID_LOGIN;
            }
        }
        return code;
    }

    private void doLogin(HttpServletRequest request, HttpServletResponse response) {
        if (!AuthUtil.isValidateRequest(request)) {
            if (AuthUtil.isBrowserRequest(request)) {
                if (!AuthUtil.isAjaxRequest(request) && !this.isLoginLoop(request)) {
                    try {
                        this.login(request, response);
                        return;
                    }
                    catch (IllegalStateException ise) {
                        this.log.error("doLogin: Cannot login: Response already committed");
                        return;
                    }
                    catch (NoAuthenticationHandlerException nahe) {
                        this.log.error("doLogin: Cannot login: No AuthenticationHandler available to handle the request");
                    }
                }
            } else if (this.httpBasicHandler != null) {
                this.httpBasicHandler.sendUnauthorized(response);
                return;
            }
        }
        this.ensureAttribute(request, "j_reason", "Authentication Failed");
        AuthUtil.sendInvalid(request, response);
    }

    private boolean isLoginLoop(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        if (referer != null) {
            StringBuffer sb = request.getRequestURL();
            if (request.getQueryString() != null) {
                sb.append('?').append(request.getQueryString());
            }
            return referer.equals(sb.toString());
        }
        return false;
    }

    private void ensureAttribute(HttpServletRequest request, String attribute, Object value) {
        if (request.getAttribute(attribute) == null) {
            request.setAttribute(attribute, value);
        }
    }

    private void setAttributes(ResourceResolver resolver, String authType, HttpServletRequest request) {
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)authType);
        if (authType != null) {
            request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)resolver.getUserID());
        }
        request.setAttribute("org.apache.sling.auth.core.ResourceResolver", (Object)resolver);
        this.log.debug("setAttributes: ResourceResolver stored as request attribute: user={}", (Object)resolver.getUserID());
    }

    private void sendSudoCookie(HttpServletResponse response, String user, int maxAge, String path, String owner) {
        String quotedUser;
        String quotedOwner = null;
        try {
            quotedUser = SlingAuthenticator.quoteCookieValue(user);
            if (owner != null) {
                quotedOwner = SlingAuthenticator.quoteCookieValue(owner);
            }
        }
        catch (IllegalArgumentException iae) {
            this.log.error("sendSudoCookie: Failed to quote value '{}' of cookie {}: {}", new Object[]{user, this.sudoCookieName, iae.getMessage()});
            return;
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("sendSudoCookie: Failed to quote value '{}' of cookie {}: {}", new Object[]{user, this.sudoCookieName, e.getMessage()});
            return;
        }
        if (quotedUser != null) {
            Cookie cookie = new Cookie(this.sudoCookieName, quotedUser);
            cookie.setMaxAge(maxAge);
            cookie.setPath(path == null || path.length() == 0 ? "/" : path);
            try {
                cookie.setComment(quotedOwner + " impersonates as " + quotedUser);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            response.addCookie(cookie);
            if (this.cacheControl) {
                response.addHeader("Cache-Control", "no-cache=\"Set-Cookie\"");
            }
        }
    }

    private void handleImpersonation(HttpServletRequest req, AuthenticationInfo authInfo) {
        String currentSudo = this.getSudoCookieValue(req);
        String sudo = req.getParameter(this.sudoParameterName);
        if (sudo == null || sudo.length() == 0) {
            sudo = currentSudo;
        } else if ("-".equals(sudo)) {
            sudo = null;
        }
        if (sudo != null && sudo.length() > 0) {
            authInfo.put("user.impersonation", (Object)sudo);
        }
    }

    private void handlePasswordChange(HttpServletRequest req, AuthenticationInfo authInfo) {
        String newPassword = req.getParameter(PAR_NEW_PASSWORD);
        if (newPassword != null && newPassword.length() > 0) {
            authInfo.put("user.newpassword", (Object)newPassword);
        }
    }

    private String getSudoCookieValue(HttpServletRequest req) {
        String currentSudo = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; currentSudo == null && i < cookies.length; ++i) {
                if (!this.sudoCookieName.equals(cookies[i].getName())) continue;
                currentSudo = SlingAuthenticator.unquoteCookieValue(cookies[i].getValue());
            }
        }
        return currentSudo;
    }

    private boolean setSudoCookie(HttpServletRequest req, HttpServletResponse res, AuthenticationInfo authInfo) {
        String currentSudo;
        boolean setCookie;
        String sudo = (String)authInfo.get("user.impersonation");
        boolean bl = setCookie = sudo != (currentSudo = this.getSudoCookieValue(req));
        if (setCookie) {
            if (sudo == null) {
                this.sendSudoCookie(res, "", 0, req.getContextPath(), authInfo.getUser());
            } else if (currentSudo == null || !currentSudo.equals(sudo)) {
                this.sendSudoCookie(res, sudo, -1, req.getContextPath(), sudo);
            }
        }
        return setCookie;
    }

    private String getHandlerSelectionPath(HttpServletRequest request) {
        String path;
        Object loginPathO = request.getAttribute("resource");
        if (loginPathO instanceof String) {
            path = (String)loginPathO;
            String ctxPath = request.getContextPath();
            if (ctxPath != null && path.startsWith(ctxPath)) {
                path = path.substring(ctxPath.length());
            }
            if (path == null || path.length() == 0) {
                path = "/";
            }
        } else {
            path = this.getPath(request);
        }
        return path;
    }

    private void redirectAfterLogout(HttpServletRequest request, HttpServletResponse response) {
        if (response.isCommitted()) {
            this.log.debug("redirectAfterLogout: Response has already been committed, not redirecting");
            return;
        }
        String target = AuthUtil.getLoginResource(request, request.getContextPath());
        if (!AuthUtil.isRedirectValid(request, target)) {
            this.log.warn("redirectAfterLogout: Desired redirect target '{}' is invalid; redirecting to '/'", (Object)target);
            target = request.getContextPath() + "/";
        }
        try {
            response.sendRedirect(target);
        }
        catch (IOException e) {
            this.log.error("Failed to redirect to the page: " + target, (Throwable)e);
        }
    }

    private void postLoginEvent(AuthenticationInfo authInfo) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("userid", authInfo.getUser());
        ((Dictionary)properties).put("sling.authType", authInfo.getAuthType());
        EventAdmin localEA = this.eventAdmin;
        if (localEA != null) {
            localEA.postEvent(new Event("org/apache/sling/auth/core/Authenticator/LOGIN", properties));
        }
    }

    private void postLoginFailedEvent(HttpServletRequest request, AuthenticationInfo authInfo, Exception reason) {
        AuthenticationHandler.FAILURE_REASON_CODES reason_code = this.getFailureReasonFromException(authInfo, reason);
        if (reason_code != null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (authInfo.getUser() != null) {
                ((Dictionary)properties).put("userid", authInfo.getUser());
            }
            if (authInfo.getAuthType() != null) {
                ((Dictionary)properties).put("sling.authType", authInfo.getAuthType());
            }
            ((Dictionary)properties).put("reason_code", reason_code.name());
            EventAdmin localEA = this.eventAdmin;
            if (localEA != null) {
                localEA.postEvent(new Event("org/apache/sling/auth/core/Authenticator/LOGIN_FAILED", properties));
            }
        }
    }

    static String quoteCookieValue(String value) throws UnsupportedEncodingException {
        if (value == null) {
            throw new IllegalArgumentException("Cookie value may not be null");
        }
        StringBuilder builder = new StringBuilder(value.length() * 2);
        builder.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '@') {
                builder.append(c);
                continue;
            }
            if (c == '\u007f' || c < ' ' && c != '\t') {
                throw new IllegalArgumentException("Cookie value may not contain CTL character");
            }
            builder.append(URLEncoder.encode(String.valueOf(c), "UTF-8"));
        }
        builder.append('\"');
        return builder.toString();
    }

    static String unquoteCookieValue(String value) {
        String[] values;
        if (value == null || value.length() == 0) {
            return value;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        StringBuilder builder = new StringBuilder();
        for (String v : values = value.split("\\\\")) {
            try {
                builder.append(URLDecoder.decode(v, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                builder.append(v);
            }
        }
        return builder.toString();
    }

    private static class EngineAuthenticationHandlerTracker
    extends AuthenticationHandlerTracker {
        EngineAuthenticationHandlerTracker(BundleContext context, PathBasedHolderCache<AbstractAuthenticationHandlerHolder> authHandlerCache) {
            super(context, "org.apache.sling.engine.auth.AuthenticationHandler", authHandlerCache);
        }

        @Override
        protected AbstractAuthenticationHandlerHolder createHolder(String path, Object handler, ServiceReference serviceReference) {
            return new EngineAuthenticationHandlerHolder(path, (org.apache.sling.engine.auth.AuthenticationHandler)handler, serviceReference);
        }
    }

    private static class AuthenticationHandlerTracker
    extends ServiceTracker {
        private final PathBasedHolderCache<AbstractAuthenticationHandlerHolder> authHandlerCache;
        private final Map<Object, AbstractAuthenticationHandlerHolder[]> handlerMap = new ConcurrentHashMap<Object, AbstractAuthenticationHandlerHolder[]>();

        AuthenticationHandlerTracker(BundleContext context, PathBasedHolderCache<AbstractAuthenticationHandlerHolder> authHandlerCache) {
            this(context, "org.apache.sling.auth.core.spi.AuthenticationHandler", authHandlerCache);
        }

        protected AuthenticationHandlerTracker(BundleContext context, String className, PathBasedHolderCache<AbstractAuthenticationHandlerHolder> authHandlerCache) {
            super(context, className, null);
            this.authHandlerCache = authHandlerCache;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (service != null) {
                this.bindAuthHandler(service, reference);
            }
            return service;
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.unbindAuthHandler(reference);
            if (service != null) {
                this.bindAuthHandler(service, reference);
            }
        }

        public void removedService(ServiceReference reference, Object service) {
            this.unbindAuthHandler(reference);
            super.removedService(reference, service);
        }

        protected AbstractAuthenticationHandlerHolder createHolder(String path, Object handler, ServiceReference serviceReference) {
            return new AuthenticationHandlerHolder(path, (AuthenticationHandler)handler, serviceReference);
        }

        private void bindAuthHandler(Object handler, ServiceReference ref) {
            String[] paths = (String[])Converters.standardConverter().convert(ref.getProperty("path")).to(String[].class);
            if (paths != null && paths.length > 0) {
                AbstractAuthenticationHandlerHolder[] holders;
                ArrayList<AbstractAuthenticationHandlerHolder> holderList = new ArrayList<AbstractAuthenticationHandlerHolder>();
                for (String path : paths) {
                    if (path == null || path.length() <= 0) continue;
                    holderList.add(this.createHolder(path, handler, ref));
                }
                for (AbstractAuthenticationHandlerHolder holder : holders = holderList.toArray(new AbstractAuthenticationHandlerHolder[holderList.size()])) {
                    this.authHandlerCache.addHolder(holder);
                }
                this.handlerMap.put(ref.getProperty("service.id"), holders);
            }
        }

        private void unbindAuthHandler(ServiceReference ref) {
            AbstractAuthenticationHandlerHolder[] holders = this.handlerMap.remove(ref.getProperty("service.id"));
            if (holders != null) {
                for (AbstractAuthenticationHandlerHolder holder : holders) {
                    this.authHandlerCache.removeHolder(holder);
                }
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling Authentication Service", description="Extracts user authentication details from the request with the help of authentication handlers registered as separate services. One example of such an authentication handler is the handler HTTP Authorization header contained authentication.")
    public static @interface Config {
        @AttributeDefinition(name="Impersonation Cookie", description="The name the HTTP Cookie to set with the value of the user which is to be impersonated. This cookie will always be a session cookie.")
        public String auth_sudo_cookie() default "sling.sudo";

        @AttributeDefinition(name="Impersonation Parameter", description="The name of the request parameter initiating impersonation. Setting this parameter to a user id will result in using an impersonated session (instead of the actually authenticated session) and set a session cookie of the name defined in the Impersonation Cookie setting.")
        public String auth_sudo_parameter() default "sudo";

        @AttributeDefinition(name="Allow Anonymous Access", description="Whether default access as anonymous when no credentials are present in the request is allowed. The default value is \"true\" to allow access without credentials. When set to \"false\" access to the repository is only allowed if valid credentials are presented. The value of this configuration option is added to list of Authentication Requirements and needs not be explicitly listed. If anonymous access is allowed the entry added is \"-/\". Otherwise anonymous access is denied and \"+/\" is added to the list.")
        public boolean auth_annonymous() default true;

        @AttributeDefinition(name="Authentication Requirements", description="Defines URL space subtrees which require or don't require authentication. For any request the best matching path configured applies and defines whether authentication is actually required for the request or not. Each entry in this list can be an absolute path (such as /content) or and absolute URI (such as http://thehost/content). Optionally each entry may be prefixed by a plus (+) or minus (-) sign indicating that authentication is required (plus) or not required (minus). Example entries are \"/content\" or \"+/content\" to require authentication at and below \"/content\" and \"-/system/sling/login\" to not require authentication at and below \"/system/sling/login\". By default this list is empty. This list is extended at run time with additional entries: One entry is added for the \"Allow Anonymous Access\" configuration. Other entries are added for any services setting the \"sling.auth.requirements\" service registration property.")
        public String[] sling_auth_requirements();

        @AttributeDefinition(name="Anonymous User Name", description="Defines which user name to assume for anonymous requests, that is requests not providing credentials supported by any of the registered authentication handlers. If this property is missing or empty, the default is assumed which depends on the resource provider(s). Otherwise anonymous requests are handled with this user name. If the configured user name does not exist or is not allowed to access the resource data, anonymous requests may still be blocked. If anonymous access is not allowed, this property is ignored.")
        public String sling_auth_anonymous_user();

        @AttributeDefinition(name="Anonymous User Password", description="Password for the anonymous user defined in the Anonymous User Name field. This property is only used if a non-empty anonymous user name is configured. If this property is not defined but a password is required, an empty password would be assumed.", type=AttributeType.PASSWORD)
        public String sling_auth_anonymous_password();

        @AttributeDefinition(name="HTTP Basic Authentication", description="Level of support for HTTP Basic Authentication. Such support can be provided in three levels: (1) no support at all, that is disabled, (2) preemptive support, that is HTTP Basic Authentication is supported if the authentication header is set in the request, (3) full support. The default is preemptive support unless Anonymous Access is not allowed. In this case HTTP Basic Authentication is always enabled to ensure clients can authenticate at least with basic authentication.", options={@Option(label="Enabled", value="enabled"), @Option(label="Enabled (Preemptive)", value="preemptive"), @Option(label="Disabled", value="disabled")})
        public String auth_http() default "preemptive";

        @AttributeDefinition(name="Realm", description="HTTP BASIC authentication realm. This property is only used if the HTTP Basic Authentication support is not disabled. The default value is \"Sling (Development)\".")
        public String auth_http_realm() default "Sling (Development)";

        @AttributeDefinition(name="Authentication URI Suffices", description="A list of request URI suffixes intended to be handled by Authentication Handlers. Any request whose request URI ends with any one of the listed suffices is intended to be handled by an Authentication Handler causing the request to either be rejected or the client being redirected to another location and thus the request not being further processed after the authentication phase. The default is just \"/j_security_check\" which is the suffix defined by the Servlet API specification used for FORM based authentication.")
        public String[] auth_uri_suffix() default {"/j_security_check"};
    }
}

