/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.impl.AbstractAuthenticationHandlerHolder;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;

final class AuthenticationHandlerHolder
extends AbstractAuthenticationHandlerHolder {
    private final AuthenticationHandler handler;
    private final String authType;
    private final boolean browserOnlyRequestCredentials;

    AuthenticationHandlerHolder(String fullPath, AuthenticationHandler handler, ServiceReference serviceReference) {
        super(fullPath, serviceReference);
        String browserOnly = PropertiesUtil.toString((Object)serviceReference.getProperty("sling.auth.browser-only"), null);
        this.handler = handler;
        this.authType = PropertiesUtil.toString((Object)serviceReference.getProperty("authtype"), null);
        this.browserOnlyRequestCredentials = "true".equalsIgnoreCase(browserOnly) || "yes".equalsIgnoreCase(browserOnly);
    }

    @Override
    protected AuthenticationFeedbackHandler getFeedbackHandler() {
        if (this.handler instanceof AuthenticationFeedbackHandler) {
            return (AuthenticationFeedbackHandler)((Object)this.handler);
        }
        return null;
    }

    @Override
    public AuthenticationInfo doExtractCredentials(HttpServletRequest request, HttpServletResponse response) {
        return this.handler.extractCredentials(request, response);
    }

    @Override
    public boolean doRequestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.doesRequestCredentials(request)) {
            return this.handler.requestCredentials(request, response);
        }
        return false;
    }

    @Override
    public void doDropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handler.dropCredentials(request, response);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj.getClass() == this.getClass()) {
            AuthenticationHandlerHolder other = (AuthenticationHandlerHolder)obj;
            return other.handler == this.handler;
        }
        return false;
    }

    public String toString() {
        return this.handler.toString();
    }

    private boolean doesRequestCredentials(HttpServletRequest request) {
        if (this.browserOnlyRequestCredentials && !AuthUtil.isBrowserRequest(request)) {
            return false;
        }
        if (this.authType == null) {
            return true;
        }
        String requestLogin = AuthUtil.getAttributeOrParameter(request, "sling:authRequestLogin", null);
        return requestLogin == null || this.authType.equals(requestLogin);
    }
}

