/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.auth.core.impl.AuthenticationRequirementHolder;
import org.apache.sling.auth.core.impl.SlingAuthenticator;

public class AuthenticatorWebConsolePlugin
extends HttpServlet {
    private final SlingAuthenticator slingAuthenticator;

    String getLabel() {
        return "slingauth";
    }

    String getTitle() {
        return "Authenticator";
    }

    public AuthenticatorWebConsolePlugin(SlingAuthenticator slingAuthenticator) {
        this.slingAuthenticator = slingAuthenticator;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod())) {
            super.service(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter pw = resp.getWriter();
        pw.println("<table class='content' width='100%' cellspacing='0' cellpadding='0'>");
        this.printAuthenticationHandler(pw);
        pw.println("<tr><td colspan='2'>&nbsp;</td></tr>");
        this.printAuthenticationRequirements(pw);
        pw.println("<tr><td colspan='2'>&nbsp;</td></tr>");
        this.printAuthenticationConfiguration(pw);
        pw.println("</table>");
    }

    private void printAuthenticationHandler(PrintWriter pw) {
        pw.println("<tr>");
        pw.println("<th class='content container' colspan='3'>Registered Authentication Handler</td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<th class='content'>Path</td>");
        pw.println("<th class='content' colspan='2'>Handler</td>");
        pw.println("</tr>");
        Map<String, List<String>> handlerMap = this.slingAuthenticator.getAuthenticationHandler();
        for (Map.Entry<String, List<String>> handler : handlerMap.entrySet()) {
            String path = handler.getKey();
            for (String name : handler.getValue()) {
                pw.println("<tr class='content'>");
                pw.printf("<td class='content'>%s</td>%n", ResponseUtil.escapeXml((String)path));
                pw.printf("<td class='content' colspan='2'>%s</td>%n", ResponseUtil.escapeXml((String)name));
                pw.println("</tr>");
            }
        }
    }

    private void printAuthenticationRequirements(PrintWriter pw) {
        pw.println("<tr>");
        pw.println("<th class='content container' colspan='3'>Authentication Requirement Configuration</td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<th class='content'>Path</td>");
        pw.println("<th class='content'>Authentication Required</td>");
        pw.println("<th class='content'>Defining Service (Description or ID)</td>");
        pw.println("</tr>");
        List<AuthenticationRequirementHolder> holderList = this.slingAuthenticator.getAuthenticationRequirements();
        for (AuthenticationRequirementHolder req : holderList) {
            pw.println("<tr class='content'>");
            pw.printf("<td class='content'>%s</td>%n", ResponseUtil.escapeXml((String)req.fullPath));
            pw.printf("<td class='content'>%s</td>%n", req.requiresAuthentication() ? "Yes" : "No");
            pw.printf("<td class='content'>%s</td>%n", ResponseUtil.escapeXml((String)req.getProvider()));
            pw.println("</tr>");
        }
    }

    private void printAuthenticationConfiguration(PrintWriter pw) {
        String anonUser = this.slingAuthenticator.getAnonUserName();
        String sudoCookie = this.slingAuthenticator.getSudoCookieName();
        String sudoParam = this.slingAuthenticator.getSudoParameterName();
        pw.println("<tr>");
        pw.println("<th class='content container' colspan='3'>Miscellaneous Configuration</td>");
        pw.println("</tr>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td class='content'>Impersonation Cookie</td>");
        pw.printf("<td class='content' colspan='2'>%s</td>%n", ResponseUtil.escapeXml((String)sudoCookie));
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td class='content'>Impersonation Parameter</td>");
        pw.printf("<td class='content' colspan='2'>%s</td>%n", ResponseUtil.escapeXml((String)sudoParam));
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td class='content'>Anonymous User Name</td>");
        pw.printf("<td class='content' colspan='2'>%s</td>%n", anonUser == null ? "(default)" : ResponseUtil.escapeXml((String)anonUser));
        pw.println("</tr>");
    }
}

