/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.auth.core.impl.AuthenticationRequirementHolder;
import org.apache.sling.auth.core.impl.PathBasedHolderCache;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class SlingAuthenticatorServiceListener
implements AllServiceListener {
    private final PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache;
    private final HashMap<Object, Set<String>> regProps = new HashMap();
    private final HashMap<Object, List<AuthenticationRequirementHolder>> props = new HashMap();

    static SlingAuthenticatorServiceListener createListener(BundleContext context, PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache) {
        SlingAuthenticatorServiceListener listener = new SlingAuthenticatorServiceListener(authRequiredCache);
        try {
            String filter = "(sling.auth.requirements=*)";
            context.addServiceListener((ServiceListener)listener, "(sling.auth.requirements=*)");
            ServiceReference[] refs = context.getAllServiceReferences(null, "(sling.auth.requirements=*)");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    listener.addService(ref);
                }
            }
            return listener;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    private SlingAuthenticatorServiceListener(PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache) {
        this.authRequiredCache = authRequiredCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        HashMap<Object, List<AuthenticationRequirementHolder>> hashMap = this.props;
        synchronized (hashMap) {
            if ((event.getType() & 0xC) != 0) {
                this.removeService(event.getServiceReference());
            }
            if ((event.getType() & 2) != 0) {
                this.modifiedService(event.getServiceReference());
            }
            if ((event.getType() & 3) != 0) {
                this.addService(event.getServiceReference());
            }
        }
    }

    void registerAllServices() {
        for (List<AuthenticationRequirementHolder> authReqs : this.props.values()) {
            this.registerService(authReqs);
        }
    }

    private void registerService(List<AuthenticationRequirementHolder> authReqs) {
        for (AuthenticationRequirementHolder authReq : authReqs) {
            this.authRequiredCache.addHolder(authReq);
        }
    }

    private Set<String> buildPathsSet(String[] authReqPaths) {
        HashSet<String> paths = new HashSet<String>();
        for (String authReq : authReqPaths) {
            if (authReq == null || authReq.length() <= 0) continue;
            paths.add(authReq);
        }
        return paths;
    }

    private void addService(ServiceReference<?> ref) {
        Set<String> paths;
        String[] authReqPaths = PropertiesUtil.toStringArray(ref.getProperty("sling.auth.requirements"));
        if (authReqPaths != null && !(paths = this.buildPathsSet(authReqPaths)).isEmpty()) {
            ArrayList<AuthenticationRequirementHolder> authReqList = new ArrayList<AuthenticationRequirementHolder>();
            for (String authReq : paths) {
                authReqList.add(AuthenticationRequirementHolder.fromConfig(authReq, ref));
            }
            this.regProps.put(ref.getProperty("service.id"), paths);
            this.registerService(authReqList);
            this.props.put(ref.getProperty("service.id"), authReqList);
        }
    }

    private void modifiedService(ServiceReference<?> ref) {
        String[] authReqPaths = PropertiesUtil.toStringArray(ref.getProperty("sling.auth.requirements"));
        if (authReqPaths != null) {
            Set<String> oldPaths = this.regProps.get(ref.getProperty("service.id"));
            if (oldPaths == null) {
                this.addService(ref);
            } else {
                Set<String> paths = this.buildPathsSet(authReqPaths);
                if (paths.isEmpty()) {
                    this.removeService(ref);
                } else {
                    AuthenticationRequirementHolder holder;
                    List<AuthenticationRequirementHolder> authReqs = this.props.get(ref.getProperty("service.id"));
                    for (String oldPath : oldPaths) {
                        if (paths.contains(oldPath)) continue;
                        holder = AuthenticationRequirementHolder.fromConfig(oldPath, ref);
                        authReqs.remove(holder);
                        this.authRequiredCache.removeHolder(holder);
                    }
                    for (String path : paths) {
                        if (oldPaths.contains(path)) continue;
                        holder = AuthenticationRequirementHolder.fromConfig(path, ref);
                        authReqs.add(holder);
                        this.authRequiredCache.addHolder(holder);
                    }
                    this.regProps.put(ref.getProperty("service.id"), paths);
                }
            }
        } else {
            this.removeService(ref);
        }
    }

    private void removeService(ServiceReference<?> ref) {
        List<AuthenticationRequirementHolder> authReqs = this.props.remove(ref.getProperty("service.id"));
        if (authReqs != null) {
            for (AuthenticationRequirementHolder authReq : authReqs) {
                this.authRequiredCache.removeHolder(authReq);
            }
        }
        this.regProps.remove(ref.getProperty("service.id"));
    }
}

