/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.auth.Authenticator;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.core.AuthUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Authentication Logout Servlet", description="Servlet for logging out users through the authenticator service.")
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Authenticator Logout Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.methods", value={"GET", "POST"}, label="Method", description="Supported Methdos", unbounded=PropertyUnbounded.ARRAY)})
public class LogoutServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile Authenticator authenticator;
    @Property(name="sling.servlet.paths")
    public static final String SERVLET_PATH = "/system/sling/logout";

    protected void service(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Authenticator authenticator = this.authenticator;
        if (authenticator != null) {
            try {
                AuthUtil.setLoginResourceAttribute((HttpServletRequest)request, null);
                authenticator.logout((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IllegalStateException ise) {
                this.log.error("service: Response already committed, cannot logout");
                return;
            }
        }
        this.log.error("service: Authenticator service missing, cannot logout");
        response.setStatus(204);
    }

    protected void bindAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void unbindAuthenticator(Authenticator authenticator) {
        if (this.authenticator == authenticator) {
            this.authenticator = null;
        }
    }
}

