/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.impl.PathBasedHolder;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.osgi.framework.ServiceReference;

public abstract class AbstractAuthenticationHandlerHolder
extends PathBasedHolder
implements AuthenticationHandler {
    protected AbstractAuthenticationHandlerHolder(String fullPath, ServiceReference serviceReference) {
        super(fullPath, serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        Object oldPathAttr = this.setPath(request);
        try {
            AuthenticationInfo authenticationInfo = this.doExtractCredentials(request, response);
            return authenticationInfo;
        }
        finally {
            this.resetPath(request, oldPathAttr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object oldPathAttr = this.setPath(request);
        try {
            boolean bl = this.doRequestCredentials(request, response);
            return bl;
        }
        finally {
            this.resetPath(request, oldPathAttr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object oldPathAttr = this.setPath(request);
        try {
            this.doDropCredentials(request, response);
        }
        finally {
            this.resetPath(request, oldPathAttr);
        }
    }

    protected abstract AuthenticationFeedbackHandler getFeedbackHandler();

    protected abstract AuthenticationInfo doExtractCredentials(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract boolean doRequestCredentials(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected abstract void doDropCredentials(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    private Object setPath(HttpServletRequest request) {
        return AbstractAuthenticationHandlerHolder.setRequestAttribute(request, "path", this.fullPath);
    }

    private void resetPath(HttpServletRequest request, Object oldValue) {
        AbstractAuthenticationHandlerHolder.setRequestAttribute(request, "path", oldValue);
    }

    private static Object setRequestAttribute(HttpServletRequest request, String name, Object value) {
        Object oldValue = request.getAttribute(name);
        if (value == null) {
            request.removeAttribute(name);
        } else {
            request.setAttribute(name, value);
        }
        return oldValue;
    }
}

