/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import org.apache.felix.http.javaxwrappers.CookieWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.RequestDispatcherWrapper;
import org.apache.felix.http.javaxwrappers.ServletRequestWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JakartaToJavaxRequestWrapper
extends HttpServletRequestWrapper
implements SlingHttpServletRequest {
    private final SlingJakartaHttpServletRequest wrappedRequest;

    public static ServletRequest toJavaxRequest(jakarta.servlet.ServletRequest request) {
        if (request instanceof JavaxToJakartaRequestWrapper) {
            return ((JavaxToJakartaRequestWrapper)request).getRequest();
        }
        if (request instanceof SlingJakartaHttpServletRequest) {
            return new JakartaToJavaxRequestWrapper((SlingJakartaHttpServletRequest)request);
        }
        if (request instanceof HttpServletRequest) {
            return new HttpServletRequestWrapper((HttpServletRequest)request);
        }
        return new ServletRequestWrapper(request);
    }

    public static javax.servlet.http.HttpServletRequest toJavaxRequest(HttpServletRequest request) {
        return (javax.servlet.http.HttpServletRequest)JakartaToJavaxRequestWrapper.toJavaxRequest((jakarta.servlet.ServletRequest)request);
    }

    public static SlingHttpServletRequest toJavaxRequest(SlingJakartaHttpServletRequest request) {
        return (SlingHttpServletRequest)JakartaToJavaxRequestWrapper.toJavaxRequest((jakarta.servlet.ServletRequest)request);
    }

    public JakartaToJavaxRequestWrapper(SlingJakartaHttpServletRequest wrappedRequest) {
        super((HttpServletRequest)wrappedRequest);
        this.wrappedRequest = wrappedRequest;
    }

    @Override
    @Nullable
    public javax.servlet.http.Cookie getCookie(String name) {
        Cookie cookie = this.wrappedRequest.getCookie(name);
        if (cookie != null) {
            return new CookieWrapper(cookie);
        }
        return null;
    }

    @Override
    @Nullable
    public RequestDispatcher getRequestDispatcher(@NotNull String path, RequestDispatcherOptions options) {
        jakarta.servlet.RequestDispatcher dispatcher = this.wrappedRequest.getRequestDispatcher(path, options);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    @Override
    @Nullable
    public RequestDispatcher getRequestDispatcher(@NotNull Resource resource, RequestDispatcherOptions options) {
        jakarta.servlet.RequestDispatcher dispatcher = this.wrappedRequest.getRequestDispatcher(resource, options);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    @Override
    @Nullable
    public RequestDispatcher getRequestDispatcher(@NotNull Resource resource) {
        jakarta.servlet.RequestDispatcher dispatcher = this.wrappedRequest.getRequestDispatcher(resource);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    @Override
    @Nullable
    public RequestParameter getRequestParameter(@NotNull String name) {
        return this.wrappedRequest.getRequestParameter(name);
    }

    @Override
    @NotNull
    public List<RequestParameter> getRequestParameterList() {
        return this.wrappedRequest.getRequestParameterList();
    }

    @Override
    @NotNull
    public RequestParameterMap getRequestParameterMap() {
        return this.wrappedRequest.getRequestParameterMap();
    }

    @Override
    @Nullable
    public RequestParameter[] getRequestParameters(@NotNull String name) {
        return this.wrappedRequest.getRequestParameters(name);
    }

    @Override
    @NotNull
    public RequestPathInfo getRequestPathInfo() {
        return this.wrappedRequest.getRequestPathInfo();
    }

    @Override
    @NotNull
    public RequestProgressTracker getRequestProgressTracker() {
        return this.wrappedRequest.getRequestProgressTracker();
    }

    @Override
    @NotNull
    public Resource getResource() {
        return this.wrappedRequest.getResource();
    }

    @Override
    @Nullable
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.wrappedRequest.getResourceBundle(locale);
    }

    @Override
    @Nullable
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return this.wrappedRequest.getResourceBundle(baseName, locale);
    }

    @Override
    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.wrappedRequest.getResourceResolver();
    }

    @Override
    @Nullable
    public String getResponseContentType() {
        return this.wrappedRequest.getResponseContentType();
    }

    @Override
    @NotNull
    public Enumeration<String> getResponseContentTypes() {
        return this.wrappedRequest.getResponseContentTypes();
    }

    @Override
    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return (AdapterType)this.wrappedRequest.adaptTo(type);
    }
}

