/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.adapter;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterManager;

public abstract class SlingAdaptable
implements Adaptable {
    private static volatile AdapterManager ADAPTER_MANAGER;
    private Map<Class<?>, Object> adaptersCache;

    public static void setAdapterManager(AdapterManager adapterMgr) {
        ADAPTER_MANAGER = adapterMgr;
    }

    public static void unsetAdapterManager(AdapterManager adapterMgr) {
        if (ADAPTER_MANAGER == adapterMgr) {
            ADAPTER_MANAGER = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        SlingAdaptable slingAdaptable = this;
        synchronized (slingAdaptable) {
            if (ADAPTER_MANAGER == null) {
                return null;
            }
            if (this.adaptersCache == null) {
                this.adaptersCache = new HashMap();
            }
            return (AdapterType)this.adaptersCache.computeIfAbsent(type, klazz -> ADAPTER_MANAGER.getAdapter(this, type));
        }
    }
}

