/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.IteratorWrapper;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class ResourceResolverWrapper
implements ResourceResolver {
    private ResourceResolver wrapped;

    public ResourceResolverWrapper(ResourceResolver resolver) {
        this.wrapped = resolver;
    }

    @Override
    @Nonnull
    public Resource resolve(@Nonnull HttpServletRequest request, @Nonnull String absPath) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(request, absPath));
    }

    @Override
    @Nonnull
    public Resource resolve(@Nonnull String absPath) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(absPath));
    }

    @Override
    @Nonnull
    public Resource resolve(@Nonnull HttpServletRequest request) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(request));
    }

    @Override
    @Nonnull
    public String map(@Nonnull String resourcePath) {
        return this.wrapped.map(resourcePath);
    }

    @Override
    public String map(@Nonnull HttpServletRequest request, @Nonnull String resourcePath) {
        return this.wrapped.map(request, resourcePath);
    }

    @Override
    public Resource getResource(@Nonnull String path) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.getResource(path));
    }

    @Override
    public Resource getResource(Resource base, @Nonnull String path) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.getResource(base, path));
    }

    @Override
    @Nonnull
    public String[] getSearchPath() {
        return this.wrapped.getSearchPath();
    }

    @Override
    @Nonnull
    public Iterator<Resource> listChildren(@Nonnull Resource parent) {
        return new ResourceIteratorWrapper(this, this.wrapped.listChildren(parent));
    }

    @Override
    public Resource getParent(@Nonnull Resource child) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.getParent(child));
    }

    @Override
    @Nonnull
    public Iterable<Resource> getChildren(final @Nonnull Resource parent) {
        final ResourceResolverWrapper resourceResolverWrapper = this;
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return new ResourceIteratorWrapper(resourceResolverWrapper, ResourceResolverWrapper.this.wrapped.getChildren(parent).iterator());
            }
        };
    }

    @Override
    @Nonnull
    public Iterator<Resource> findResources(@Nonnull String query, String language) {
        return new ResourceIteratorWrapper(this, this.wrapped.findResources(query, language));
    }

    @Override
    @Nonnull
    public Iterator<Map<String, Object>> queryResources(@Nonnull String query, String language) {
        return this.wrapped.queryResources(query, language);
    }

    @Override
    public boolean hasChildren(@Nonnull Resource resource) {
        return this.wrapped.hasChildren(resource);
    }

    @Override
    @Nonnull
    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        ResourceResolver toWrap = this.wrapped.clone(authenticationInfo);
        return new ResourceResolverWrapper(toWrap);
    }

    @Override
    public boolean isLive() {
        return this.wrapped.isLive();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    public String getUserID() {
        return this.wrapped.getUserID();
    }

    @Override
    @Nonnull
    public Iterator<String> getAttributeNames() {
        return this.wrapped.getAttributeNames();
    }

    @Override
    public Object getAttribute(@Nonnull String name) {
        return this.wrapped.getAttribute(name);
    }

    @Override
    public void delete(@Nonnull Resource resource) throws PersistenceException {
        this.wrapped.delete(resource);
    }

    @Override
    @Nonnull
    public Resource create(@Nonnull Resource parent, @Nonnull String name, Map<String, Object> properties) throws PersistenceException {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.create(parent, name, properties));
    }

    @Override
    public void revert() {
        this.wrapped.revert();
    }

    @Override
    public void commit() throws PersistenceException {
        this.wrapped.commit();
    }

    @Override
    public boolean hasChanges() {
        return this.wrapped.hasChanges();
    }

    @Override
    public String getParentResourceType(Resource resource) {
        return this.wrapped.getParentResourceType(resource);
    }

    @Override
    public String getParentResourceType(String resourceType) {
        return this.wrapped.getParentResourceType(resourceType);
    }

    @Override
    public boolean isResourceType(Resource resource, String resourceType) {
        return this.wrapped.isResourceType(resource, resourceType);
    }

    @Override
    public void refresh() {
        this.wrapped.refresh();
    }

    @Override
    public Resource copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.copy(srcAbsPath, destAbsPath));
    }

    @Override
    public Resource move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.move(srcAbsPath, destAbsPath));
    }

    @Override
    public <AdapterType> AdapterType adaptTo(@Nonnull Class<AdapterType> type) {
        return this.wrapped.adaptTo(type);
    }

    private static class ResourceIteratorWrapper
    extends IteratorWrapper<Resource> {
        private final ResourceResolverWrapper resolver;

        public ResourceIteratorWrapper(ResourceResolverWrapper resolver, Iterator<Resource> wrappedIterator) {
            super(wrappedIterator);
            this.resolver = resolver;
        }

        @Override
        public Resource next() {
            return ResourceResolverResourceWrapper.wrap(this.resolver, (Resource)super.next());
        }
    }

    private static class ResourceResolverResourceWrapper
    extends ResourceWrapper {
        private final ResourceResolverWrapper resolver;

        ResourceResolverResourceWrapper(ResourceResolverWrapper resolver, Resource resource) {
            super(resource);
            this.resolver = resolver;
        }

        @Override
        public ResourceResolver getResourceResolver() {
            return this.resolver;
        }

        private static Resource wrap(ResourceResolverWrapper resolver, Resource resource) {
            if (resource != null) {
                return new ResourceResolverResourceWrapper(resolver, resource);
            }
            return null;
        }
    }
}

