/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.scripting;

import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;

public class SlingBindings
extends HashMap<String, Object> {
    private static final long serialVersionUID = 209505693646323450L;
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String READER = "reader";
    public static final String SLING = "sling";
    public static final String RESOURCE = "resource";
    public static final String RESOLVER = "resolver";
    public static final String OUT = "out";
    public static final String FLUSH = "flush";
    public static final String LOG = "log";

    protected <ObjectType> ObjectType get(String key, Class<ObjectType> type) {
        Object o = this.get(key);
        if (type.isInstance(o)) {
            return (ObjectType)o;
        }
        return null;
    }

    protected void safePut(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    public void setFlush(boolean flush) {
        this.put(FLUSH, flush);
    }

    public boolean getFlush() {
        Boolean value = this.get(FLUSH, Boolean.class);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setLog(Logger log) {
        this.safePut(LOG, log);
    }

    @CheckForNull
    public Logger getLog() {
        return this.get(LOG, Logger.class);
    }

    public void setOut(PrintWriter out) {
        this.safePut(OUT, out);
    }

    @CheckForNull
    public PrintWriter getOut() {
        return this.get(OUT, PrintWriter.class);
    }

    public void setRequest(SlingHttpServletRequest request) {
        this.safePut(REQUEST, request);
    }

    @CheckForNull
    public SlingHttpServletRequest getRequest() {
        return this.get(REQUEST, SlingHttpServletRequest.class);
    }

    public void setReader(Reader reader) {
        this.safePut(READER, reader);
    }

    @CheckForNull
    public Reader getReader() {
        return this.get(READER, Reader.class);
    }

    public void setResource(Resource resource) {
        this.safePut(RESOURCE, resource);
    }

    @CheckForNull
    public Resource getResource() {
        return this.get(RESOURCE, Resource.class);
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.safePut(RESOLVER, resourceResolver);
    }

    @CheckForNull
    public ResourceResolver getResourceResolver() {
        return this.get(RESOLVER, ResourceResolver.class);
    }

    public void setResponse(SlingHttpServletResponse response) {
        this.safePut(RESPONSE, response);
    }

    @CheckForNull
    public SlingHttpServletResponse getResponse() {
        return this.get(RESPONSE, SlingHttpServletResponse.class);
    }

    public void setSling(SlingScriptHelper sling) {
        this.safePut(SLING, sling);
    }

    @CheckForNull
    public SlingScriptHelper getSling() {
        return this.get(SLING, SlingScriptHelper.class);
    }
}

