/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.scripting.jsp.jasper.IOProvider;

public class JspCIOProvider
implements IOProvider {
    private final ClassLoader loader;
    private final JavaCompiler compiler;
    private final ClassLoaderWriter writer;

    JspCIOProvider(ClassLoader loader, JavaCompiler compiler, ClassLoaderWriter writer) {
        this.loader = loader;
        this.compiler = compiler;
        this.writer = writer;
    }

    private File getFile(String fileName) {
        return new File(fileName);
    }

    public OutputStream getOutputStream(String fileName) throws IOException {
        return FileUtils.openOutputStream((File)this.getFile(fileName));
    }

    public InputStream getInputStream(String fileName) throws IOException {
        File file = this.getFile(fileName);
        if (file.exists()) {
            return FileUtils.openInputStream((File)this.getFile(fileName));
        }
        String jarEntryPath = fileName.startsWith("/") ? fileName.substring(1) : fileName;
        URL url = this.loader.getResource(jarEntryPath);
        if (url != null) {
            return url.openStream();
        }
        throw new FileNotFoundException("Cannot find file " + fileName + ".");
    }

    public boolean delete(String fileName) {
        return this.getFile(fileName).delete();
    }

    public boolean rename(String oldFileName, String newFileName) {
        return this.getFile(oldFileName).renameTo(this.getFile(newFileName));
    }

    public boolean mkdirs(String path) {
        return this.getFile(path).mkdirs();
    }

    public long lastModified(String fileName) {
        return this.getFile(fileName).lastModified();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public JavaCompiler getJavaCompiler() {
        return this.compiler;
    }

    public ClassLoaderWriter getClassLoaderWriter() {
        return this.writer;
    }
}

