/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.impl.EclipseJavaCompiler;
import org.apache.sling.maven.jspc.JspCClassLoaderWriter;
import org.apache.sling.maven.jspc.JspCIOProvider;
import org.apache.sling.maven.jspc.JspCServletContext;
import org.apache.sling.maven.jspc.JspCTldLocationsCache;
import org.apache.sling.maven.jspc.TrackingClassLoader;
import org.apache.sling.scripting.jsp.jasper.IOProvider;
import org.apache.sling.scripting.jsp.jasper.JasperException;
import org.apache.sling.scripting.jsp.jasper.JspCompilationContext;
import org.apache.sling.scripting.jsp.jasper.Options;
import org.apache.sling.scripting.jsp.jasper.compiler.JspConfig;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.compiler.TagPluginManager;
import org.apache.sling.scripting.jsp.jasper.compiler.TldLocationsCache;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="jspc", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class JspcMojo
extends AbstractMojo
implements Options {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="jspc.sourceDirectory", defaultValue="${project.build.scriptSourceDirectory}")
    private File sourceDirectory;
    @Parameter
    private File[] resourceDirectories = new File[0];
    @Parameter(property="jspc.outputDirectory", defaultValue="${project.build.outputDirectory}")
    private String outputDirectory;
    @Parameter(property="jspc.jasper.classdebuginfo", defaultValue="true")
    private boolean jasperClassDebugInfo;
    @Parameter(property="jspc.jasper.enablePooling", defaultValue="true")
    private boolean jasperEnablePooling;
    @Parameter(property="jspc.jasper.ieClassId", defaultValue="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93")
    private String jasperIeClassId;
    @Parameter(property="jspc.jasper.genStringAsCharArray", defaultValue="false")
    private boolean jasperGenStringAsCharArray;
    @Parameter(property="jspc.jasper.keepgenerated", defaultValue="true")
    private boolean jasperKeepGenerated;
    @Parameter(property="jspc.jasper.mappedfile", defaultValue="true")
    private boolean jasperMappedFile;
    @Parameter(property="jspc.jasper.trimSpaces", defaultValue="false")
    private boolean jasperTrimSpaces;
    @Parameter(property="jspc.jasper.suppressSmap", defaultValue="false")
    private boolean jasperSuppressSmap;
    @Parameter(property="jspc.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="jspc.showSuccess", defaultValue="false")
    private boolean showSuccess;
    @Parameter(property="jspc.compilerTargetVM", defaultValue="1.8")
    private String compilerTargetVM;
    @Parameter(property="jspc.compilerSourceVM", defaultValue="1.8")
    private String compilerSourceVM;
    @Parameter(property="jspc.printCompilationReport", defaultValue="false")
    private boolean printCompilationReport;
    @Deprecated
    @Parameter(property="jspc.jspFileExtensions", defaultValue="jsp,jspx")
    private String jspFileExtensions;
    @Parameter(property="jspc.servletPackage")
    private String servletPackage;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    private String uriSourceRoot;
    private List<String> pages = new ArrayList<String>();
    private JspCServletContext context;
    private JspRuntimeContext rctxt;
    private TrackingClassLoader loader;
    private List<Artifact> jspcCompileArtifacts;
    private TldLocationsCache tldLocationsCache;
    private JspConfig jspConfig;
    private TagPluginManager tagPluginManager;

    public void execute() throws MojoExecutionException {
        try {
            this.uriSourceRoot = this.sourceDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            this.uriSourceRoot = this.sourceDirectory.getAbsolutePath();
        }
        File outputDirectoryFile = new File(this.outputDirectory);
        if (!outputDirectoryFile.isDirectory()) {
            if (outputDirectoryFile.exists()) {
                throw new MojoExecutionException(this.outputDirectory + " exists but is not a directory");
            }
            if (!outputDirectoryFile.mkdirs()) {
                throw new MojoExecutionException("Cannot create output directory " + this.outputDirectory);
            }
        }
        String previousJasperPackageName = null;
        String oldValue = System.getProperty("org.apache.commons.logging.Log");
        try {
            System.setProperty("org.apache.commons.logging.Log", SimpleLog.class.getName());
            previousJasperPackageName = System.setProperty("org.apache.sling.scripting.jsp.jasper.Constants.JSP_PACKAGE_NAME", this.servletPackage != null ? this.servletPackage : "");
            this.executeInternal();
            if (this.printCompilationReport) {
                this.printCompilationReport();
            }
        }
        catch (JasperException je) {
            this.getLog().error((CharSequence)"Compilation Failure", (Throwable)je);
            throw new MojoExecutionException(je.getMessage(), (Exception)((Object)je));
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("org.apache.commons.logging.Log");
            } else {
                System.setProperty("org.apache.commons.logging.Log", oldValue);
            }
            if (previousJasperPackageName == null) {
                System.clearProperty("org.apache.sling.scripting.jsp.jasper.Constants.JSP_PACKAGE_NAME");
            } else {
                System.setProperty("org.apache.sling.scripting.jsp.jasper.Constants.JSP_PACKAGE_NAME", previousJasperPackageName);
            }
        }
        this.project.addCompileSourceRoot(this.outputDirectory);
    }

    private void scanFiles(File base) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(base);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        Collections.addAll(this.pages, scanner.getIncludedFiles());
    }

    private void executeInternal() throws JasperException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("execute() starting for " + this.pages.size() + " pages."));
        }
        try {
            File uriRootF;
            if (this.context == null) {
                this.initServletContext();
            }
            if (this.includes == null) {
                this.includes = new String[]{"**/*.jsp"};
            }
            if (this.pages.size() == 0) {
                this.scanFiles(this.sourceDirectory);
            }
            if (!(uriRootF = new File(this.uriSourceRoot)).exists() || !uriRootF.isDirectory()) {
                throw new JasperException("The source location '" + this.uriSourceRoot + "' must be an existing directory");
            }
            ((Stream)this.pages.stream().parallel()).forEach(nextjsp -> {
                File fjsp = new File((String)nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, (String)nextjsp);
                }
                if (!fjsp.exists()) {
                    if (this.getLog().isWarnEnabled()) {
                        this.getLog().warn((CharSequence)("JSP file " + fjsp + " does not exist"));
                    }
                } else {
                    String s = fjsp.getAbsolutePath();
                    if (s.startsWith(this.uriSourceRoot)) {
                        nextjsp = s.substring(this.uriSourceRoot.length());
                    }
                    if (nextjsp.startsWith("." + File.separatorChar)) {
                        nextjsp = nextjsp.substring(2);
                    }
                    try {
                        this.processFile((String)nextjsp);
                    }
                    catch (JasperException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                rootCause.printStackTrace();
            }
            throw je;
        }
        catch (Exception ioe) {
            throw new JasperException((Throwable)ioe);
        }
    }

    private void processFile(String file) throws JasperException {
        try {
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, (Options)this, (ServletContext)this.context, this.rctxt, false);
            JasperException error = clctxt.compile();
            if (error != null) {
                throw error;
            }
            if (this.showSuccess) {
                this.getLog().info((CharSequence)("Built File: " + file));
            }
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                this.getLog().error((CharSequence)("General problem compiling " + file), rootCause);
            }
            if (this.failOnError) {
                throw je;
            }
            this.getLog().error((CharSequence)je.getMessage());
        }
        catch (Exception e) {
            throw new JasperException((Throwable)e);
        }
    }

    private void initServletContext() throws IOException, DependencyResolutionRequiredException {
        if (this.loader == null) {
            this.initClassLoader();
        }
        this.context = new JspCServletContext(this.getLog(), new URL("file:" + this.uriSourceRoot.replace('\\', '/') + '/'));
        for (File resourceDir : this.resourceDirectories) {
            String root = resourceDir.getCanonicalPath().replace('\\', '/');
            URL altUrl = new URL("file:" + root + "/");
            this.context.addAlternativeBaseURL(altUrl);
        }
        this.tldLocationsCache = new JspCTldLocationsCache(this.context, true, this.loader);
        EclipseJavaCompiler compiler = new EclipseJavaCompiler();
        JspCClassLoaderWriter writer = new JspCClassLoaderWriter(this.loader, new File(this.outputDirectory));
        JspCIOProvider ioProvider = new JspCIOProvider(this.loader, (JavaCompiler)compiler, writer);
        this.rctxt = new JspRuntimeContext((ServletContext)this.context, (Options)this, (IOProvider)ioProvider);
        this.jspConfig = new JspConfig((ServletContext)this.context);
        this.tagPluginManager = new TagPluginManager((ServletContext)this.context);
    }

    private void initClassLoader() throws IOException, DependencyResolutionRequiredException {
        ArrayList<URL> classPath = new ArrayList<URL>();
        String targetDirectory = this.project.getBuild().getOutputDirectory();
        classPath.add(new File(targetDirectory).toURI().toURL());
        Set artifacts = this.project.getDependencyArtifacts();
        this.jspcCompileArtifacts = new ArrayList<Artifact>(artifacts.size());
        for (Artifact a : artifacts) {
            String scope = a.getScope();
            if (!"provided".equals(scope) && !"runtime".equals(scope) && !"compile".equals(scope) || this.containsProblematicPackage(a.getFile())) continue;
            classPath.add(a.getFile().toURI().toURL());
            this.jspcCompileArtifacts.add(a);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Compiler classpath:");
            for (URL u : classPath) {
                this.getLog().debug((CharSequence)("  " + u));
            }
        }
        this.loader = new TrackingClassLoader(classPath.toArray(new URL[classPath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private boolean containsProblematicPackage(File file) throws IOException {
        JarFile jar = new JarFile(file);
        boolean isJSPApi = jar.getEntry("/javax/servlet/jsp/JspPage.class") != null;
        jar.close();
        return isJSPApi;
    }

    private void printCompilationReport() {
        if (this.loader == null) {
            return;
        }
        HashMap<String, Set<String>> artifactsByPackage = new HashMap<String, Set<String>>();
        HashSet<String> usedDependencies = new HashSet<String>();
        for (Artifact a : this.jspcCompileArtifacts) {
            this.scanArtifactPackages(artifactsByPackage, a);
            usedDependencies.add(a.getId());
        }
        StringBuilder report = new StringBuilder("JSP compilation report:\n\n");
        ArrayList<String> packages = new ArrayList<String>(this.loader.getPackageNames());
        int pad = 10;
        for (String packageName : artifactsByPackage.keySet()) {
            pad = Math.max(pad, packageName.length());
        }
        report.append(StringUtils.rightPad((String)"Package", (int)(pad += 2))).append("Dependency");
        report.append("\n---------------------------------------------------------------\n");
        Collections.sort(packages);
        for (String packageName : packages) {
            report.append(StringUtils.rightPad((String)packageName, (int)pad));
            Set a = (Set)artifactsByPackage.get(packageName);
            if (a == null || a.isEmpty()) {
                report.append("n/a");
            } else {
                StringBuilder ids = new StringBuilder();
                for (String id : a) {
                    usedDependencies.remove(id);
                    if (ids.length() > 0) {
                        ids.append(", ");
                    }
                    ids.append(id);
                }
                report.append((CharSequence)ids);
            }
            report.append("\n");
        }
        report.append("\n");
        report.append(usedDependencies.size()).append(" dependencies not used by JSPs:\n");
        if (!usedDependencies.isEmpty()) {
            report.append("---------------------------------------------------------------\n");
            for (String id : usedDependencies) {
                report.append(id).append("\n");
            }
        }
        int doubleDefined = 0;
        StringBuilder msg = new StringBuilder();
        packages = new ArrayList(artifactsByPackage.keySet());
        Collections.sort(packages);
        for (String packageName : packages) {
            Set a = (Set)artifactsByPackage.get(packageName);
            if (a == null || a.size() <= 1) continue;
            ++doubleDefined;
            msg.append(StringUtils.rightPad((String)packageName, (int)pad));
            msg.append(StringUtils.join(a.iterator(), (String)", ")).append("\n");
        }
        report.append("\n");
        report.append(doubleDefined).append(" packages are multiply defined by dependencies:\n");
        if (doubleDefined > 0) {
            report.append("---------------------------------------------------------------\n");
            report.append((CharSequence)msg);
        }
        this.getLog().info((CharSequence)report);
    }

    private void scanArtifactPackages(Map<String, Set<String>> artifactsByPackage, Artifact a) {
        try {
            JarFile jar = new JarFile(a.getFile());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String packageName;
                Set<String> artifacts;
                String path;
                JarEntry e = entries.nextElement();
                if (e.isDirectory() || !(path = e.getName()).endsWith(".class")) continue;
                if ((path = StringUtils.chomp((String)path, (String)"/")).charAt(0) == '/') {
                    path = path.substring(1);
                }
                if ((artifacts = artifactsByPackage.get(packageName = path.replaceAll("/", "."))) == null) {
                    artifacts = new HashSet<String>();
                    artifactsByPackage.put(packageName, artifacts);
                }
                artifacts.add(a.getId());
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error while accessing jar file: " + e.getMessage()));
        }
    }

    public boolean genStringAsCharArray() {
        return this.jasperGenStringAsCharArray;
    }

    public boolean getClassDebugInfo() {
        return this.jasperClassDebugInfo;
    }

    public String getCompiler() {
        return null;
    }

    public String getCompilerClassName() {
        return null;
    }

    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return true;
    }

    public boolean getFork() {
        return false;
    }

    public String getIeClassId() {
        return this.jasperIeClassId;
    }

    public String getJavaEncoding() {
        return "UTF-8";
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public boolean getKeepGenerated() {
        return this.jasperKeepGenerated;
    }

    public boolean getMappedFile() {
        return this.jasperMappedFile;
    }

    public String getScratchDir() {
        return this.outputDirectory;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public boolean getTrimSpaces() {
        return this.jasperTrimSpaces;
    }

    public boolean isPoolingEnabled() {
        return this.jasperEnablePooling;
    }

    public boolean isSmapDumped() {
        return true;
    }

    public boolean isSmapSuppressed() {
        return this.jasperSuppressSmap;
    }

    public boolean isXpoweredBy() {
        return false;
    }

    public boolean getDisplaySourceFragment() {
        return true;
    }
}

