/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class ResourceUtil {
    public static InputStream getResourceAsStream(String resourcePath) {
        String path = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceAsString(String resource) throws IOException {
        InputStream resourceAsStream = ResourceUtil.getResourceAsStream(resource);
        if (resourceAsStream != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8.name()));
                while ((line = reader.readLine()) != null) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(line);
                }
            }
            finally {
                resourceAsStream.close();
            }
            return sb.toString();
        }
        return null;
    }
}

