/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v5;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.plugin.elasticsearch.v5.ElasticSearchEnhanceInfo;
import org.apache.skywalking.apm.util.StringUtil;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;

public class TransportProxyClientInterceptor
implements InstanceConstructorInterceptor {
    private static final ILog logger = LogManager.getLogger(TransportProxyClientInterceptor.class);

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        Settings settings = (Settings)allArguments[0];
        String clusterName = settings.get("cluster.name");
        EnhancedInstance nodeService = (EnhancedInstance)allArguments[2];
        List genericActions = (List)allArguments[3];
        for (GenericAction action : genericActions) {
            if (!(action instanceof EnhancedInstance)) continue;
            ElasticSearchEnhanceInfo elasticSearchEnhanceInfo = new ElasticSearchEnhanceInfo();
            elasticSearchEnhanceInfo.setClusterName(clusterName);
            this.parseRequestInfo(action, elasticSearchEnhanceInfo);
            elasticSearchEnhanceInfo.setTransportAddressHolder(nodeService);
            ((EnhancedInstance)action).setSkyWalkingDynamicField((Object)elasticSearchEnhanceInfo);
        }
    }

    private void parseRequestInfo(Object request, ElasticSearchEnhanceInfo enhanceInfo) {
        if (request instanceof SearchRequest) {
            this.parseSearchRequest(request, enhanceInfo);
            return;
        }
        if (request instanceof GetRequest) {
            this.parseGetRequest(request, enhanceInfo);
            return;
        }
        if (request instanceof IndexRequest) {
            this.parseIndexRequest(request, enhanceInfo);
            return;
        }
        if (request instanceof UpdateRequest) {
            this.parseUpdateRequest(request, enhanceInfo);
            return;
        }
        if (request instanceof DeleteRequest) {
            this.parseDeleteRequest(request, enhanceInfo);
        }
    }

    private void parseSearchRequest(Object request, ElasticSearchEnhanceInfo enhanceInfo) {
        SearchRequest searchRequest = (SearchRequest)request;
        enhanceInfo.setIndices(StringUtil.join((char)',', (String[])searchRequest.indices()));
        enhanceInfo.setTypes(StringUtil.join((char)',', (String[])searchRequest.types()));
        if (Config.Plugin.Elasticsearch.TRACE_DSL) {
            enhanceInfo.setSource(null == searchRequest.source() ? "" : searchRequest.source().toString());
        }
    }

    private void parseGetRequest(Object request, ElasticSearchEnhanceInfo enhanceInfo) {
        GetRequest getRequest = (GetRequest)request;
        enhanceInfo.setIndices(StringUtil.join((char)',', (String[])getRequest.indices()));
        enhanceInfo.setTypes(getRequest.type());
        if (Config.Plugin.Elasticsearch.TRACE_DSL) {
            enhanceInfo.setSource(getRequest.toString());
        }
    }

    private void parseIndexRequest(Object request, ElasticSearchEnhanceInfo enhanceInfo) {
        IndexRequest indexRequest = (IndexRequest)request;
        enhanceInfo.setIndices(StringUtil.join((char)',', (String[])indexRequest.indices()));
        enhanceInfo.setTypes(indexRequest.type());
        if (Config.Plugin.Elasticsearch.TRACE_DSL) {
            enhanceInfo.setSource(indexRequest.toString());
        }
    }

    private void parseUpdateRequest(Object request, ElasticSearchEnhanceInfo enhanceInfo) {
        UpdateRequest updateRequest = (UpdateRequest)request;
        enhanceInfo.setIndices(StringUtil.join((char)',', (String[])updateRequest.indices()));
        enhanceInfo.setTypes(updateRequest.type());
        if (Config.Plugin.Elasticsearch.TRACE_DSL) {
            String updateDsl = "";
            try {
                updateDsl = updateRequest.toXContent(XContentFactory.jsonBuilder(), null).string();
            }
            catch (IOException e) {
                logger.warn("trace update request dsl error: ", new Object[]{e});
            }
            enhanceInfo.setSource(updateDsl);
        }
    }

    private void parseDeleteRequest(Object request, ElasticSearchEnhanceInfo enhanceInfo) {
        DeleteRequest deleteRequest = (DeleteRequest)request;
        enhanceInfo.setIndices(StringUtil.join((char)',', (String[])deleteRequest.indices()));
        enhanceInfo.setTypes(deleteRequest.type());
        if (Config.Plugin.Elasticsearch.TRACE_DSL) {
            enhanceInfo.setSource(deleteRequest.toString());
        }
    }
}

