/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.undertow.v2x;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ExecuteRootHandlerInterceptor
implements StaticMethodsAroundInterceptor {
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        HttpServerExchange exchange = (HttpServerExchange)allArguments[1];
        ContextCarrier contextCarrier = new ContextCarrier();
        HeaderMap headers = exchange.getRequestHeaders();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(headers.getFirst(next.getHeadKey()));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)exchange.getRequestPath(), (ContextCarrier)contextCarrier);
        Tags.URL.set(span, exchange.getRequestURL());
        Tags.HTTP.METHOD.set(span, exchange.getRequestMethod().toString());
        span.setComponent((Component)ComponentsDefine.UNDERTOW);
        SpanLayer.asHttp((AbstractSpan)span);
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        HttpServerExchange exchange = (HttpServerExchange)allArguments[1];
        AbstractSpan span = ContextManager.activeSpan();
        if (exchange.getStatusCode() >= 400) {
            span.errorOccurred();
            Tags.STATUS_CODE.set(span, Integer.toString(exchange.getStatusCode()));
        }
        ContextManager.stopSpan();
        ContextManager.getRuntimeContext().remove((Object)"SW_FORWARD_REQUEST_FLAG");
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

