/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type.simple;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.algorithm.sharding.ShardingValue;
import io.shardingjdbc.core.hint.HintManagerHolder;
import io.shardingjdbc.core.hint.ShardingKey;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.parsing.parser.context.condition.Condition;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.routing.type.RoutingEngine;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.TableUnit;
import io.shardingjdbc.core.rule.DataNode;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class SimpleRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final List<Object> parameters;
    private final String logicTableName;
    private final SQLStatement sqlStatement;

    @Override
    public RoutingResult route() {
        TableRule tableRule = this.shardingRule.getTableRule(this.logicTableName);
        List<ShardingValue> databaseShardingValues = this.getDatabaseShardingValues(tableRule);
        List<ShardingValue> tableShardingValues = this.getTableShardingValues(tableRule);
        Collection<String> routedDataSources = this.routeDataSources(tableRule, databaseShardingValues);
        LinkedList<DataNode> routedDataNodes = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            routedDataNodes.addAll(this.routeTables(tableRule, each, tableShardingValues));
        }
        return this.generateRoutingResult(routedDataNodes);
    }

    private List<ShardingValue> getDatabaseShardingValues(TableRule tableRule) {
        ShardingStrategy strategy = this.shardingRule.getDatabaseShardingStrategy(tableRule);
        return HintManagerHolder.isUseShardingHint() ? this.getDatabaseShardingValuesFromHint(strategy.getShardingColumns()) : this.getShardingValues(strategy.getShardingColumns());
    }

    private List<ShardingValue> getTableShardingValues(TableRule tableRule) {
        ShardingStrategy strategy = this.shardingRule.getTableShardingStrategy(tableRule);
        return HintManagerHolder.isUseShardingHint() ? this.getTableShardingValuesFromHint(strategy.getShardingColumns()) : this.getShardingValues(strategy.getShardingColumns());
    }

    private List<ShardingValue> getDatabaseShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey(this.logicTableName, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue> getTableShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue> shardingValue = HintManagerHolder.getTableShardingValue(new ShardingKey(this.logicTableName, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue> getShardingValues(Collection<String> shardingColumns) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<Condition> condition = this.sqlStatement.getConditions().find(new Column(each, this.logicTableName));
            if (!condition.isPresent()) continue;
            result.add(((Condition)condition.get()).getShardingValue(this.parameters));
        }
        return result;
    }

    private Collection<String> routeDataSources(TableRule tableRule, List<ShardingValue> databaseShardingValues) {
        Collection<String> availableTargetDatabases = tableRule.getActualDatasourceNames();
        if (databaseShardingValues.isEmpty()) {
            return availableTargetDatabases;
        }
        Collection<String> result = this.shardingRule.getDatabaseShardingStrategy(tableRule).doSharding(availableTargetDatabases, databaseShardingValues);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        return result;
    }

    private Collection<DataNode> routeTables(TableRule tableRule, String routedDataSource, List<ShardingValue> tableShardingValues) {
        Collection<String> availableTargetTables = tableRule.getActualTableNames(routedDataSource);
        Collection<String> routedTables = tableShardingValues.isEmpty() ? availableTargetTables : this.shardingRule.getTableShardingStrategy(tableRule).doSharding(availableTargetTables, tableShardingValues);
        Preconditions.checkState((!routedTables.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    private RoutingResult generateRoutingResult(Collection<DataNode> routedDataNodes) {
        RoutingResult result = new RoutingResult();
        for (DataNode each : routedDataNodes) {
            result.getTableUnits().getTableUnits().add(new TableUnit(each.getDataSourceName(), this.logicTableName, each.getTableName()));
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "parameters", "logicTableName", "sqlStatement"})
    public SimpleRoutingEngine(ShardingRule shardingRule, List<Object> parameters, String logicTableName, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.parameters = parameters;
        this.logicTableName = logicTableName;
        this.sqlStatement = sqlStatement;
    }
}

