/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.LexerEngineFactory;
import io.shardingjdbc.core.parsing.parser.sql.SQLParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.rule.ShardingRule;
import java.beans.ConstructorProperties;

public final class SQLParsingEngine {
    private final DatabaseType dbType;
    private final String sql;
    private final ShardingRule shardingRule;

    public SQLStatement parse() {
        LexerEngine lexerEngine = LexerEngineFactory.newInstance(this.dbType, this.sql);
        lexerEngine.nextToken();
        return SQLParserFactory.newInstance(this.dbType, lexerEngine.getCurrentToken().getType(), this.shardingRule, lexerEngine).parse();
    }

    @ConstructorProperties(value={"dbType", "sql", "shardingRule"})
    public SQLParsingEngine(DatabaseType dbType, String sql, ShardingRule shardingRule) {
        this.dbType = dbType;
        this.sql = sql;
        this.shardingRule = shardingRule;
    }
}

