/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger.groupby;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.merger.common.MemoryResultSetRow;
import io.shardingjdbc.core.merger.util.ResultSetUtil;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;

public final class GroupByRowComparator
implements Comparator<MemoryResultSetRow> {
    private final SelectStatement selectStatement;

    @Override
    public int compare(MemoryResultSetRow o1, MemoryResultSetRow o2) {
        if (!this.selectStatement.getOrderByItems().isEmpty()) {
            return this.compare(o1, o2, this.selectStatement.getOrderByItems());
        }
        return this.compare(o1, o2, this.selectStatement.getGroupByItems());
    }

    private int compare(MemoryResultSetRow o1, MemoryResultSetRow o2, List<OrderItem> orderItems) {
        for (OrderItem each : orderItems) {
            Object orderValue1 = o1.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue1 || orderValue1 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            Object orderValue2 = o2.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue2 || orderValue2 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            int result = ResultSetUtil.compareTo((Comparable)orderValue1, (Comparable)orderValue2, each.getType(), each.getNullOrderType());
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @ConstructorProperties(value={"selectStatement"})
    public GroupByRowComparator(SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
    }
}

