/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.keygen.KeyGenerator;
import io.shardingjdbc.core.keygen.KeyGeneratorFactory;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.rule.TableRule;
import io.shardingjdbc.core.util.InlineExpressionParser;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class TableRuleConfiguration {
    private String logicTable;
    private String actualDataNodes;
    private ShardingStrategyConfiguration databaseShardingStrategyConfig;
    private ShardingStrategyConfiguration tableShardingStrategyConfig;
    private String keyGeneratorColumnName;
    private String keyGeneratorClass;
    private String logicIndex;

    public TableRule build(Map<String, DataSource> dataSourceMap) {
        Preconditions.checkNotNull((Object)this.logicTable, (Object)"Logic table cannot be null.");
        List<String> actualDataNodes = new InlineExpressionParser(this.actualDataNodes).evaluate();
        ShardingStrategy databaseShardingStrategy = null == this.databaseShardingStrategyConfig ? null : this.databaseShardingStrategyConfig.build();
        ShardingStrategy tableShardingStrategy = null == this.tableShardingStrategyConfig ? null : this.tableShardingStrategyConfig.build();
        KeyGenerator keyGenerator = !Strings.isNullOrEmpty((String)this.keyGeneratorColumnName) && !Strings.isNullOrEmpty((String)this.keyGeneratorClass) ? KeyGeneratorFactory.newInstance(this.keyGeneratorClass) : null;
        return new TableRule(this.logicTable, actualDataNodes, dataSourceMap, databaseShardingStrategy, tableShardingStrategy, this.keyGeneratorColumnName, keyGenerator, this.logicIndex);
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public String getActualDataNodes() {
        return this.actualDataNodes;
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfig() {
        return this.databaseShardingStrategyConfig;
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfig() {
        return this.tableShardingStrategyConfig;
    }

    public String getKeyGeneratorColumnName() {
        return this.keyGeneratorColumnName;
    }

    public String getKeyGeneratorClass() {
        return this.keyGeneratorClass;
    }

    public String getLogicIndex() {
        return this.logicIndex;
    }

    public void setLogicTable(String logicTable) {
        this.logicTable = logicTable;
    }

    public void setActualDataNodes(String actualDataNodes) {
        this.actualDataNodes = actualDataNodes;
    }

    public void setDatabaseShardingStrategyConfig(ShardingStrategyConfiguration databaseShardingStrategyConfig) {
        this.databaseShardingStrategyConfig = databaseShardingStrategyConfig;
    }

    public void setTableShardingStrategyConfig(ShardingStrategyConfiguration tableShardingStrategyConfig) {
        this.tableShardingStrategyConfig = tableShardingStrategyConfig;
    }

    public void setKeyGeneratorColumnName(String keyGeneratorColumnName) {
        this.keyGeneratorColumnName = keyGeneratorColumnName;
    }

    public void setKeyGeneratorClass(String keyGeneratorClass) {
        this.keyGeneratorClass = keyGeneratorClass;
    }

    public void setLogicIndex(String logicIndex) {
        this.logicIndex = logicIndex;
    }
}

