/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2TableInstaller
extends ModelInstaller {
    private static final Logger logger = LoggerFactory.getLogger(H2TableInstaller.class);

    public H2TableInstaller(ModuleManager moduleManager) {
        super(moduleManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isExists(Client client, Model model) throws StorageException {
        TableMetaInfo.addModel(model);
        JDBCHikariCPClient h2Client = (JDBCHikariCPClient)client;
        try (Connection conn = h2Client.getConnection();
             ResultSet rset = conn.getMetaData().getTables(null, null, model.getName(), null);){
            if (!rset.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
        catch (JDBCClientException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
    }

    protected void createTable(Client client, Model model) throws StorageException {
        JDBCHikariCPClient h2Client = (JDBCHikariCPClient)client;
        SQLBuilder tableCreateSQL = new SQLBuilder("CREATE TABLE IF NOT EXISTS " + model.getName() + " (");
        tableCreateSQL.appendLine("id VARCHAR(300) PRIMARY KEY, ");
        for (int i = 0; i < model.getColumns().size(); ++i) {
            ModelColumn column = (ModelColumn)model.getColumns().get(i);
            ColumnName name = column.getColumnName();
            tableCreateSQL.appendLine(name.getStorageName() + " " + this.getColumnType(model, name, column.getType()) + (i != model.getColumns().size() - 1 ? "," : ""));
        }
        tableCreateSQL.appendLine(")");
        if (logger.isDebugEnabled()) {
            logger.debug("creating table: " + tableCreateSQL.toStringInNewLine());
        }
        try (Connection connection = h2Client.getConnection();){
            h2Client.execute(connection, tableCreateSQL.toString());
        }
        catch (JDBCClientException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getColumnType(Model model, ColumnName name, Class<?> type) {
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return "INT";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return "BIGINT";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return "DOUBLE";
        }
        if (String.class.equals(type)) {
            return "VARCHAR(2000)";
        }
        if (IntKeyLongValueArray.class.equals(type)) {
            return "VARCHAR(20000)";
        }
        if (byte[].class.equals(type)) {
            return "VARCHAR(20000)";
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }
}

