/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2ServiceInstanceInventoryCacheDAO
extends H2SQLExecutor
implements IServiceInstanceInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2ServiceInstanceInventoryCacheDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2ServiceInstanceInventoryCacheDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public ServiceInstanceInventory get(int serviceInstanceId) {
        try {
            return (ServiceInstanceInventory)this.getByColumn(this.h2Client, "service_instance_inventory", "sequence", serviceInstanceId, (StorageBuilder)new ServiceInstanceInventory.Builder());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getServiceInstanceId(int serviceId, String uuid) {
        String id = ServiceInstanceInventory.buildId((int)serviceId, (String)uuid);
        return this.getByID(id);
    }

    public int getServiceInstanceId(int serviceId, int addressId) {
        String id = ServiceInstanceInventory.buildId((int)serviceId, (int)addressId);
        return this.getByID(id);
    }

    private int getByID(String id) {
        return this.getEntityIDByID(this.h2Client, "sequence", "service_instance_inventory", id);
    }
}

