/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2RegisterLockInstaller {
    private static final Logger logger = LoggerFactory.getLogger(H2RegisterLockInstaller.class);
    static final String LOCK_TABLE_NAME = "register_lock";

    public void install(Client client, H2RegisterLockDAO dao) throws StorageException {
        JDBCHikariCPClient h2Client = (JDBCHikariCPClient)client;
        SQLBuilder tableCreateSQL = new SQLBuilder("CREATE TABLE IF NOT EXISTS register_lock (");
        tableCreateSQL.appendLine("id int PRIMARY KEY, ");
        tableCreateSQL.appendLine("sequence int, ");
        tableCreateSQL.appendLine("name VARCHAR(100)");
        tableCreateSQL.appendLine(")");
        if (logger.isDebugEnabled()) {
            logger.debug("creating table: " + tableCreateSQL.toStringInNewLine());
        }
        try (Connection connection = h2Client.getConnection();){
            h2Client.execute(connection, tableCreateSQL.toString());
            for (Class registerSource : InventoryStreamProcessor.getInstance().getAllRegisterSources()) {
                int scopeId = registerSource.getAnnotation(Stream.class).scopeId();
                this.putIfAbsent(h2Client, connection, scopeId, DefaultScopeDefine.nameOf((int)1));
            }
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private void putIfAbsent(JDBCHikariCPClient h2Client, Connection connection, int scopeId, String scopeName) throws StorageException {
        Throwable throwable;
        boolean existed = false;
        try {
            throwable = null;
            try (ResultSet resultSet = h2Client.executeQuery(connection, "select 1 from register_lock where id = " + scopeId, new Object[0]);){
                if (resultSet.next()) {
                    existed = true;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
        if (!existed) {
            try {
                throwable = null;
                try (PreparedStatement statement = connection.prepareStatement("insert into register_lock(id, sequence, name)  values (?, ?, ?)");){
                    statement.setInt(1, scopeId);
                    statement.setInt(2, 1);
                    statement.setString(3, scopeName);
                    statement.execute();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                throw new StorageException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

